#include <stddef.h>
#include <assert.h>
#include <math.h>
#include <fec.h>

#include "scf.h"
#include "scf_code.h"

static uint64_t rng;

int scf_code[SCF_SYMBOL_M][SCF_CHIPS];
int scf_code_linear[SCF_CHIPS][SCF_SYMBOL_M * SCF_CHIPS];

static int get_random_code(void)
{
    rng = 6364136223846793005ULL * rng + 1;
    uint32_t random_int = rng >> 33;
    return random_int % SCF_FREQS - SCF_FREQSPAN;
}

void scf_code_generate(uint64_t seed)
{
    rng = seed;

    for (size_t m = 0; m < SCF_SYMBOL_M; m++) {
        for (size_t c = 0; c < SCF_CHIPS; c++) {
            scf_code[m][c] = get_random_code();

            // Precompute waterfall 2D array 1D indices
            for (size_t waterfall_idx = 0; waterfall_idx < SCF_CHIPS; waterfall_idx++) {
                size_t w = (waterfall_idx + c + 1) % SCF_CHIPS;
                size_t f = scf_code[m][c] + SCF_FREQSPAN;
                size_t waterfall_linear_idx = w * SCF_FREQS + f;
                scf_code_linear[waterfall_idx][m * SCF_CHIPS + c] = waterfall_linear_idx;
            }
        }
    }
}
