#ifndef __SCF_H
#define __SCF_H

#include <stdint.h>

#define SCF_SYMBOL_M 256
#define SCF_CHIPS 25 /* chips */
#define SCF_FREQSPAN 18 /* bins */
#define SCF_SRATE 8000 /* samples per second */
#define SCF_CHIP_LEN 320 /* samples */

#define SCF_FREQS (SCF_FREQSPAN * 2 + 1)
#define SCF_SYMBOL_LEN (SCF_CHIP_LEN * SCF_CHIPS)

#define SCF_MSG_LEN 100 /* bytes */
#define SCF_PARITY_LEN 20 /* bytes */

struct scf_packet {
    uint8_t message[SCF_MSG_LEN];
    uint8_t crc[3];
    uint8_t parity[SCF_PARITY_LEN];
} __attribute__((packed));

#define SCF_PKT_LEN sizeof(struct scf_packet)

struct scf_soft_symbol {
    float weight;
    uint8_t symbol;
};

#endif
