/*
  A part of this program is taken from Jason Mildrum, NT7S.
  All extra functions are written by me, Rob Engberts PA0RWE

  References:
  http://nt7s.com/
  http://sq9nje.pl/
  http://ak2b.blogspot.com/
  http://pa0rwe.nl/?page_id=804

 *  SI5351_VFO control program for Arduino NANO
 *  Copyright PA0RWE Rob Engberts
 *  
 *  Using the Si5351 library by Jason Mildrun nt7s
 *
 *  Functions:
 *  - CLK0 - Tx frequency = Display frequency
 *  - CLK1 - Rx / RIT frequency = Tx +/- BFO (upper- or lower mixing)
 *           When RIT active, RIT frequency is displayed and is tunable.
 *           When RIT is inactive Rx = Tx +/- BFO
 *  - CLK2 - BFO frequency, tunable
 *
 *  - Stepsize:  select (pushbutton)
 *  - Calibrate: (pushbutton) calculates difference between X-tal and measured
 *               x-tal frequency, to correct x-tal frequency.
 *  - Selection: (pushbutton) Switch between TRx and BFO mode
 *  - RIT switch: tunable Rx frequency, while Tx frequency not changed
 *  - Programming PIC by ICSP
 *  
 *  Si5351 settings: I2C address is in the .h file
 *                   X-tal freq is in the .h file but set in line 345
 *
***************************************************************************
 *  02-04-2015   0.1    Start building program based on the PIC version
 *  11-03-2019   1.1    Добавлена индикация любительских диапазонов,и коммутация ДПФ для диапазонов 160(пин D9),80(пин D10) и 40(пин D11) метров(Arduino Nano).
 *  28-03-2019   1.1t    Добавлены режимы USB-LSB,автовыбор режимов под диапазон,ручная смена режима.Переключение режимов по кругу кнопкой на корпус на пине D8 Arduino Nano.
 *  28-03-2019   1.1t    Не финальная версия.Основная проблема-все частоты на выходах обновляются ТОЛЬКО!!! при вращении энкодера.После включения выполняются слегка некорректно.
 *  08-04-2019   1.2    Финальная версия.Все частоты обновляются при вращении энкодера и нажатиях определённх кнопок.Добавлен аналоговый показометр на А0.Пределы 0-1,1 вольта.
 *  08-04-2019   1.2    Все сохранения частот перемещены на вход и выход из калибровки.
***************************************************************************/


/*Для успешной сборки проэкта,необходимы СТРОГО УКАЗАННЫЕ версии некоторых подключаемых библиотек:
*Etherkit Si5351 ver.2.0.6;
*Adafruit-GFX latest version;
*Adafruit SSD1306 ver.1.2.0;
Несоответствие библиотек вызовет невозможность сборки,или заторможенную работу устройства*/


/*************************************************************************
*  Includes
**************************************************************************/

#include <Rotary.h>
#include <si5351.h> 
//#include <SPI.h>
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <EEPROM.h>

/**************************************************************************
*  Definitions
**************************************************************************/
#define ENCODER_A     2       // Encoder pin A INT0/PCINT18 D2
#define ENCODER_B     3       // Encoder pin B INT1/PCINT19 D3
#define ENCODER_BTN   4       // Encoder pushbutton D4
//#define OLED_RESET    8       // OLED reset не используется,если дисплей подключён по I2C.Для подключения SPI необходимо задействовать,но в этом скетче,вероятно,работать не будет.
#define Calibrbtn     5       // Calibrate
#define RIT_Switch    6       // RIT Switch
#define TX_Switch     7       // Select TRx or BFO
#define BAND_160_OUT  9       //Выход для включения ДПФ диапазона 160 метров
#define BAND_80_OUT   10      //Выход для включения ДПФ диапазона 80 метров
#define BAND_40_OUT   11      //Выход для включения ДПФ диапазона 40 метров
#define USB_LSB       8       //вход для кнопки USB-LSB

#define F_MIN        1000000UL        // Lower frequency limit limit 1MHz
#define F_MAX        1600000000UL      // Upper frequency limit установлен лимит частоты в 160 МГц,согласно документации Si5351

/**************************************************************************
*  EEPROM data locations 
**************************************************************************/
#define EE_SAVED_RADIX  0   // Stepsize pointer
#define EE_SAVED_AFREQ  4   // Actual Tx Frequency (CLK0)
#define EE_SAVED_BFREQ  8   // BFO (IF) Frequency  (CLK2)
#define EE_SAVED_XFREQ  12  // X-tal frequency  (25 or 27 MHz)
#define EE_SAVED_OFSET  16  // store correction
#define EE_SAVED_CALBR  20  // calibrated indicator
#define EE_SAVED_UBFO   24  // под сохранение второго опорного генератора
#define EE_SAVED_MODE   28  // под сохранение режима USB/LSB
#define EE_SAVED_VCOR   32  // corr coeff for voltmeter

#define SCREEN_WIDTH  128   //разрешение дисплея
#define SCREEN_HEIGHT  64   //разрешение дисплея.Иначе возможно некорректное отображение
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire); // OLED_RESET);  //в строку добавлены\удалены данные.
/*данные необходимы для новых,или не правленных библиотек.Автоматически переключают библиотеку на 128*64*/
Si5351 si5351;
Rotary r = Rotary(ENCODER_A, ENCODER_B);


/**************************************************************************
*  Declarations
**************************************************************************/
volatile uint32_t bfo_f = 9000000ULL / SI5351_FREQ_MULT;    // CLK0 start IF    убрал по 2 нуля в конце,в ходе экспериментов
volatile uint32_t vfo_t = 14200000ULL / SI5351_FREQ_MULT;   // CLK2 start Tx freq  убрал по 2 нуля в конце,в ходе экспериментов
volatile uint32_t vfo_r = vfo_t - bfo_f;                      // CLK1 start Rx
volatile uint32_t vfo_s = vfo_t;                              // Saved for RIT
uint32_t vco_c = 0;                                           // X-tal correction factor
uint32_t xt_freq;
long radix = 100L, old_radix = 100L;                          //start step size
boolean changed_f = 0, stepflag = 0, calflag = 0, modeflag = 0, ritset = 0, UBFOflag = 0,USBLSBflag = 0,handflag = 0,tooupdate = 0;
boolean calibrate = 0;
byte  act_clk = 0; 
byte disp_txt = 0;
unsigned long time_oled_update; //переменная для таймера обновления дмсплея
volatile uint32_t bfo_U = 9000000ULL; // SI5351_FREQ_MULT;                        //дополнительный опорник на выходе BFO - UBFO
unsigned long time_volt_update; //переменная для таймера обновления вольтметра

byte mypowerpin = 14; //пин для показометра
int mypower;          //переменная для складывания результатов измерений показометра
byte mybattpin = 15; //for voltage measurement (26.01.2021)
int mybatt;          //переменная для складывания результатов измерений вольтметра

int volt_corr = 1123;
int temp_volt_corr; //temporary saved correction for voltmeter


/**************************************/
/* Interrupt service routine for      */
/* encoder frequency change           */
/**************************************/
ISR(PCINT2_vect) {
  char result = r.process();
  if (result == DIR_CW)
    set_frequency(1);
  else if (result == DIR_CCW)
    set_frequency(-1);
    
}


/**************************************/
/* Change the frequency               */
/* dir = 1    Increment               */
/* dir = -1   Decrement               */
/**************************************/
void set_frequency(short dir)
{
  switch (act_clk)
  {
    case 0:                 // Tx frequency
      if (dir == 1)
        vfo_t += radix;
      if (dir == -1)
        vfo_t -= radix;
      break;
    case 1:                 // Tx frequency (only if RIT is on)
      if (dir == 1)
        vfo_t += radix;
      if (dir == -1)
        vfo_t -= radix;
      break;
    case 2:                 // BFO frequency
      if (dir == 1)
        bfo_f += radix;
      if (dir == -1)
        bfo_f -= radix;
      break;
      case 3:               // Дополнительный опорник UBFO
      if (dir == 1)
      bfo_U += radix;
      if (dir == -1)
      bfo_U -= radix;
      break;
      case 4:               // Регулировка коррекции вольтметра
      if (dir == 1)
      volt_corr += 1;
      if (dir == -1)
      volt_corr -= 1;
      break;
      
  }

  if(vfo_t > F_MAX)
    vfo_t = F_MAX;
  if(vfo_t < F_MIN)
    vfo_t = F_MIN;

  changed_f = 1;  //признак,что частота была обновлена.Позволяет изменить частоту на выходе синтезатора и обновить дисплей.
}


/**************************************/
/* Read the buttons with debouncing   */
/**************************************/
boolean get_button()
{
  if (!digitalRead(ENCODER_BTN))            // Stepsize
  {
    delay(20);
    if (!digitalRead(ENCODER_BTN))
    {
      while (!digitalRead(ENCODER_BTN));
      stepflag = 1;      
    }
  }
  else if (!digitalRead(Calibrbtn))         // Calibrate
  {
    delay(20);
    if (!digitalRead(Calibrbtn))
    {
      while (!digitalRead(Calibrbtn));
      calflag = 1;
    }
  }
  else if (!digitalRead(TX_Switch))         // Selection
  {
    delay(20);
    if (!digitalRead(TX_Switch))
    {
      while (!digitalRead(TX_Switch));
      modeflag = 1;
      tooupdate = 1;
    }
  }  
   else if (!digitalRead(USB_LSB))         // Обработчик кнопки USB-LSB с антидребезгом
  {
    delay(20);
    if (!digitalRead(USB_LSB))
    {
      while (!digitalRead(USB_LSB));
      UBFOflag = 1;
      handflag = 1; //признак использования ручного переключения USB-LSB.Для автоматического или ручного выбора.Сбрасывается в программе индикации диапазонов.
      tooupdate = 1;//Указание программе,что была нажата кнопка смены LBFO-UBFO,и частоты необходимо обновить.Сбрасывается в программе обновления частот.
    }
  } 
  if (stepflag | calflag | modeflag | UBFOflag) return 1;
  else return 0;
}


/********************************************************************************
 * RIT switch handling
 * Switch to small stepsize (100 Hz)
 *******************************************************************************/
void RIT_switch()                               // Read RIT_switch
{
  if (!digitalRead(RIT_Switch) && ritset == 0  && calibrate == 0){     //(25.01.2021 RIT on если кнопка рит нажата и режим рит не включён и сейчас НЕ режим калибровки ТО включаем рит
    act_clk = 1;
    ritset = 1;
    vfo_s = vfo_t;                              // Save Tx freq
    old_radix = radix;                          // Save actual stepsize
    radix = 100;                                // Set stepsize to 100 Hz
  }
  else if (digitalRead(RIT_Switch) && ritset == 1){ // RIT 0ff (25.01.2021) если кнопка рит отпущена и режим рит включён - то выключаем рит
    act_clk = 0;                                // RTx mode
    ritset = 0;
    vfo_t = vfo_s;                              // Restore to original vco_t
    radix = old_radix;                          // Back to old stepsize
    disp_txt = 0;                               // Clear line
    
/* Update Rx frequency based on the restored Tx frequency    
    if (vfo_t <= bfo_f) vfo_r = vfo_t + bfo_f;  // Upper / lower mixing  
    else vfo_r = vfo_t - bfo_f;    
    si5351.set_freq((vfo_r * SI5351_FREQ_MULT), SI5351_CLK1);*/
    if (USBLSBflag == 0 && vfo_t <= bfo_f) vfo_r = vfo_t + bfo_f;      // Upper / lower mixing  
    else if  (USBLSBflag == 0) vfo_r = vfo_t - bfo_f;
//else vfo_r = vfo_t - bfo_f;
    else if  (USBLSBflag == 1 && vfo_t <= bfo_U) vfo_r = vfo_t + bfo_U;
    else if  (USBLSBflag == 1) vfo_r = vfo_t - bfo_U;  
//  if  (USBLSBflag == 1 && vfo_t <= bfo_U) vfo_r = vfo_t + bfo_U;
//  else vfo_r = vfo_t - bfo_U;  
    si5351.set_freq((vfo_r * SI5351_FREQ_MULT), SI5351_CLK1);


  }
}

/**************************************/
/* Displays the frequency and stepsize*/
/**************************************/
void display_frequency()
{ display.display();
  display.setTextSize(2);  
  char LCDstr[12];
  char Mhz[5], Herz[12];
  int p,q;
  unsigned long freq;
  display.clearDisplay();

  switch(act_clk)
  {
    case 0:                               // Tx frequency
      freq = vfo_t;
      break;
    case 1:                               // Tx frequency (Used in RIT Mode)
      freq = vfo_t;
      break;
    case 2:                               // MF frequency
      freq = bfo_f;
      break;
      case 3:
      freq = bfo_U;
      break;                              //дополнительный BFO
      case 4:
      freq = volt_corr;                   //коррекция вольтметра
      break;
      
  }
    
  Herz[1]='\0';                           // empty arry

  sprintf(LCDstr, "%8ld", freq);           // convert freq to string
  p=strlen(LCDstr);  // determine length

  strncpy(Mhz,LCDstr,(p-6));              // get MHz digits (1-3)
  q=p-6;
  Mhz[q]='\0';                            // end with null character
  strcpy(Herz,LCDstr);                    // get Herz digits (6)
  strcpy(LCDstr+q,Herz+(q-1));            // copy into LCDstr
  LCDstr[q]='.';                          // decimal point

  display.setCursor(10,0);
  display.println(LCDstr);
  display_settings();
}





/**************************************/
/* Displays step, mode and version    */
/**************************************/
void display_settings()
{
// Stepsize  
  display.setCursor(4, 40); //координаты дисплея для отображения шага частоты 
  display.setTextSize(1);  
  display.print(F("Step:"));
  switch (radix)
  {
    case 1:
      display.println(F("   1Hz"));
      break;
    case 10:
      display.println(F("  10Hz"));
      break;
    case 100:
      display.println(F(" 100Hz"));
      break;
    case 1000:
      display.println(F("  1kHz"));
      break;
    case 10000:
      display.println(F(" 10kHz"));
      break;
    case 100000:
      display.println(F("100kHz"));
      break;
    case 1000000:
      display.println(F("  1MHz"));
      break;
  }

// Mode
  display.setCursor(100, 40);  //координаты дисплея для отображения режима работы
  switch (act_clk)
  {
    case 0:
      display.println(F("TRx"));
      break;
    case 1:
      display.println(F("RIT"));
      break;
    case 2:
      display.println(F("LBFO"));
      break;
      case 3:
      display.println(F("UBFO")); //дополнительный опорник
      break;
      case 4:
      display.println(F("Vcor")); //voltmeter correction
      break;
      
  }

// Version  
//  display.setCursor(15, 55);  //координаты дисплея для отображения инфо о версии
//  display.print(F("Si5351 vfo V.1.2")); //номер версии увеличен дважды,так как сделаны изменения

// Messages
  display.setCursor(12, 25);
  switch (disp_txt)
  {
    case 0:
      display.print(F("                 "));   // clear line    
      break;
    case 1:
      display.print(F("      RIT Off!   "));
      break;
    case 2:
      display.print(F("*Set to TRx!*    "));
      break;
    case 3:
      display.print(F("Calibration!     "));
      break;      
    case 4:
      display.print(F("*     Cal.OK!    "));
      break;      
  }

 

}


/**************************************/
/*            S E T U P               */
/**************************************/
void setup()
{
pinMode(mypowerpin, INPUT);//выбор входа для показометра
analogReference(INTERNAL);  //опорное напряжение для схемы измерения-встроенное,1.1 вольта.Соотв.,пределы измерений ДО 1.1 вольт.
pinMode(mybattpin, INPUT); //select input for voltage measurement (26.01.2021)
analogReference(INTERNAL);
  
  //Serial.begin(115200);// Закомментирован.Кода использования COM-порта я не заметил.Высвободил немного памяти.
  Wire.begin();
//  Wire.setClock(400000); // Попытка повысить частоту I2C.Пока не проверял,но вроде-безуспешная.Не работает на arduino 1.8.5 и выше.Отключена.
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);  // initialize with the I2C addr 0x3C (for the 128x64)

// Read EEPROM
  radix = eeprom_read_dword((const uint32_t *)EE_SAVED_RADIX);
  if ((radix < 10UL) | (radix > 1000000UL)) radix = 100UL;  
  
  vfo_t = eeprom_read_dword((const uint32_t *)EE_SAVED_AFREQ);
  if ((vfo_t < F_MIN) | (vfo_t > F_MAX)) vfo_t = 14000000ULL;

  bfo_f = eeprom_read_dword((const uint32_t *)EE_SAVED_BFREQ);
  if ((bfo_f < 1000ULL) | (bfo_f > F_MAX)) bfo_f = 9000000ULL;

  bfo_U = eeprom_read_dword((const uint32_t *)EE_SAVED_UBFO);
  if ((bfo_U < 1000ULL) | (bfo_U > F_MAX)) bfo_U = 9000000ULL;

  vco_c = 0;
  if (eeprom_read_dword((const uint32_t *)EE_SAVED_CALBR) == 0x60)  {
    vco_c = eeprom_read_dword((const uint32_t *)EE_SAVED_OFSET);
  }  
  xt_freq = SI5351_XTAL_FREQ + vco_c;

  USBLSBflag = eeprom_read_dword((const uint32_t *)EE_SAVED_MODE); //считываем режим из памяти
  handflag = 1;                                                    //но только в том случае,если нет признака ручного выбора полосы

  
  volt_corr = eeprom_read_dword((const uint32_t *)EE_SAVED_VCOR);  //read correction for voltmeter
  if (volt_corr <= 100 || volt_corr >= 2000){
  volt_corr = 1023;}  //if volt correction is out of range,use is default coeff = 1023.

//initialize the Si5351
  si5351.set_correction(0); // Set to zero because I'm using an other calibration method
  si5351.init(SI5351_CRYSTAL_LOAD_8PF, xt_freq, 0); //If you're using a 27Mhz crystal, put in 27000000 instead of 0
  // 0 is the default crystal frequency of 25Mhz.
  si5351.set_pll(SI5351_PLL_FIXED, SI5351_PLLA);
  
// Set CLK0 to output the starting "vfo" frequency as set above by vfo = ?
 // si5351.set_freq((vfo_t * SI5351_FREQ_MULT), SI5351_CLK0);
//  si5351.drive_strength(SI5351_CLK0,SI5351_DRIVE_2MA);
// Set CLK1 to output the Rx frequncy = vfo +/- bfo frequency
//  if (vfo_t <= bfo_f) vfo_r = vfo_t + bfo_f;    // Upper / lower mixing  
//  else vfo_r = vfo_t - bfo_f;

      if (USBLSBflag == 0)
      si5351.set_freq((bfo_f * SI5351_FREQ_MULT), SI5351_CLK2); 
      else if (USBLSBflag == 1)
      si5351.set_freq((bfo_U * SI5351_FREQ_MULT), SI5351_CLK2);
      si5351.drive_strength(SI5351_CLK1,SI5351_DRIVE_2MA);

// Update Rx frequency    
    if (USBLSBflag == 0 && vfo_t <= bfo_f) vfo_r = vfo_t + bfo_f;      // Upper / lower mixing  
    else if (USBLSBflag == 0) vfo_r = vfo_t - bfo_f;
    else if (USBLSBflag == 1 && vfo_t <= bfo_U) vfo_r = vfo_t + bfo_U;
    else if (USBLSBflag == 1) vfo_r = vfo_t - bfo_U;    
    si5351.set_freq((vfo_r * SI5351_FREQ_MULT), SI5351_CLK1);    
  
  si5351.drive_strength(SI5351_CLK1,SI5351_DRIVE_2MA);
// Set CLK2 to output bfo frequency
//  si5351.set_freq((bfo_f * SI5351_FREQ_MULT), SI5351_CLK2);
//  si5351.drive_strength(SI5351_CLK2,SI5351_DRIVE_2MA);

// Clear the buffer.
  display.clearDisplay();
  display.display();
  
// text display tests
  display.setTextSize(1);
  display.setTextColor(WHITE);
  
// Encoder setup
  pinMode(ENCODER_BTN, INPUT_PULLUP);
  PCICR |= (1 << PCIE2);                       // Enable pin change interrupt for the encoder
  PCMSK2 |= (1 << PCINT18) | (1 << PCINT19);

  sei();

// Pin Setup
  pinMode(Calibrbtn, INPUT_PULLUP);   // Calibrate
  pinMode(RIT_Switch, INPUT_PULLUP);  // RIT Switch
  pinMode(TX_Switch, INPUT_PULLUP);   // Select TRx or BFO or UBFO
  pinMode(BAND_160_OUT, OUTPUT); //пин включения дпф 160
  pinMode(BAND_80_OUT, OUTPUT);  //пин включения дпф 80
  pinMode(BAND_40_OUT, OUTPUT);  //пин включения дпф 40
  pinMode(USB_LSB,INPUT_PULLUP); //кнопка USB_LSB
  
// Display first time  
  display_frequency();  // Update the display  Обновление дисплея осталось только здесь,сразу после загрузки частоты из EEPROM.
  /*и ещё один вызов в конце кода*/

 
  
}

/**************************************/
/*             L O O P                */
/**************************************/
void loop()
{
  if (disp_txt == 4) 
  {
 //   disp_txt = 4;                 //Сообщение Calibration OK
 //   delay(1000);                  // Display calibration OK and wait 3 seconds
    disp_txt = 0;
  }
// Update the display if the frequency has been changed
  
  if (changed_f == 1 || tooupdate == 1)
 {
    //display_frequency();   //обновление дисплея ПЕРЕД обновлением частоты убрал.

    void freq_update();
    {
  
    if (act_clk == 0 && !calibrate)                   // No Tx update during calibrate
      {/*si5351.set_freq((vfo_t * SI5351_FREQ_MULT), SI5351_CLK0)*/;
      if (USBLSBflag == 0 && vfo_t <= bfo_f) vfo_r = vfo_t + bfo_f;      // Upper / lower mixing  
      else if (USBLSBflag == 0) vfo_r = vfo_t - bfo_f;
      else if (USBLSBflag == 1 && vfo_t <= bfo_U) vfo_r = vfo_t + bfo_U;
      else if (USBLSBflag == 1) vfo_r = vfo_t - bfo_U;    
      si5351.set_freq((vfo_r * SI5351_FREQ_MULT), SI5351_CLK1);
            if (USBLSBflag == 0)
      si5351.set_freq((bfo_f * SI5351_FREQ_MULT), SI5351_CLK2); 
      else if (USBLSBflag == 1)
      si5351.set_freq((bfo_U * SI5351_FREQ_MULT), SI5351_CLK2); }
    else if (act_clk == 2)                            // BFO update
    
//    

      si5351.set_freq((bfo_f * SI5351_FREQ_MULT), SI5351_CLK2); 
      else if (act_clk == 3)
      si5351.set_freq((bfo_U * SI5351_FREQ_MULT), SI5351_CLK2);
 //     if (USBLSBflag == 0)
 //     si5351.set_freq((bfo_f * SI5351_FREQ_MULT), SI5351_CLK2); 
 //     else if (USBLSBflag == 1)
 //     si5351.set_freq((bfo_U * SI5351_FREQ_MULT), SI5351_CLK2);     
// Update Rx frequency    
    if (USBLSBflag == 0 && vfo_t <= bfo_f) vfo_r = vfo_t + bfo_f;      // Upper / lower mixing  
    else if (USBLSBflag == 0) vfo_r = vfo_t - bfo_f;
    else if (USBLSBflag == 1 && vfo_t <= bfo_U) vfo_r = vfo_t + bfo_U;
    else if (USBLSBflag == 1) vfo_r = vfo_t - bfo_U;    
    si5351.set_freq((vfo_r * SI5351_FREQ_MULT), SI5351_CLK1);
    
    display_frequency();    //обновление дисплея ПОСЛЕ обновления частоты добавил/перенёс.
    
    changed_f = 0;
    disp_txt = 0;                   // Clear line
    tooupdate = 0;
    }
 }

  RIT_switch();                     // read RIT switch
  
// Button press changes the frequency change step for 1 Hz steps
// Also stored the last used frequency together with the step size before store
  if (get_button()) {
    if (stepflag) {                 // Stepsize button
     // eeprom_write_dword((uint32_t *)EE_SAVED_RADIX, radix);   //отключил
     // eeprom_write_dword((uint32_t *)EE_SAVED_AFREQ, vfo_t);   //отключил
     /*решил отключить,чтобы не убить EEPROM частой перезаписью.*/
  
      switch (radix)
      {
      case 1:
        radix = 10;
        break;
      case 10:
        radix = 100;
        break;
      case 100:
        radix = 1000;
        break;
      case 1000:
        radix = 10000;
        break;
      case 10000:
        radix = 100000;
        break;
      case 100000:
        radix = 1000000;
        break;
      case 1000000:
        radix = 10;
        break;       
      }
      stepflag  = 0;
    }
    else if (modeflag && calibrate)
    {modeflag =0;}
    else if (modeflag)  {         // Mode button
    if (act_clk == 0) act_clk = 2;  //Если 0,то установить 2,если 2 то установить 3,если 3 то установить 0.
     else if (act_clk == 2) act_clk = 3;  //0= режим TRX,2=режим BFO,3=добавленный режим UBFO.
    else if (act_clk == 3) act_clk = 4;
      else act_clk = 0;
   //   eeprom_write_dword((uint32_t *)EE_SAVED_BFREQ, bfo_f);  //Сохранение основного опорника BFO
   //   eeprom_write_dword((uint32_t *)EE_SAVED_UBFO, bfo_U);   //Сохранение добавленного опорника UBFO
      modeflag = 0;  
      disp_txt = 0;// Clear line

    }
  
 
     

    
    
   else if (calflag) {                             // Calibrate button
      if (!digitalRead(RIT_Switch)){                // RIT is on
        disp_txt = 1;                               // Message RIT off
      }
      else if (act_clk == 2)                       // BFO mode on
        disp_txt = 2;                               // Message BFO off
        else if (act_clk == 3)                       // BFO mode on
        disp_txt = 2;                               // Message BFO off             
      
      else if (!calibrate)  {                       // Start calibrate
        
        
        vfo_s = vfo_t;                              // Save actual freq
        old_radix = radix;                          // and stepsize
        vfo_t = xt_freq;//SI5351_XTAL_FREQ;         // en set to default x-tal частота кварца с уже внесёнными поправками отправляется на дисплей и на выход CLK0 сишки 
        display.setCursor(12, 25);
        display.print(F("    "));

 
        disp_txt = 3;                               // Message Calibrate
        calibrate = 1;
        radix = 10;                                 // Set to 10 Hz        
        si5351.set_freq((vfo_t * SI5351_FREQ_MULT), SI5351_CLK0); // Set CLK0
        
        
        }
   
      
      else if (calibrate) {                         // after tuning x-tal freq
        calibrate = 0;
        vco_c = vfo_t - SI5351_XTAL_FREQ;           // difference
        vfo_t = vfo_s;                              // restore freq
        radix = old_radix;                          // and stepsize
        disp_txt = 4;                               // Message Calibrate OK

        xt_freq = SI5351_XTAL_FREQ + vco_c;   //перенёс сложение частоты кварца с поправочным коэфф.сюда.Чтобы сохранить уже сложенное.
        eeprom_write_dword((uint32_t *)EE_SAVED_OFSET, vco_c);        // store correction   ofset,vco_c
     //   xt_freq = SI5351_XTAL_FREQ + vco_c;                           // Calibrated x-tal freq  //закомментировал.Глупо сохранять поправку без внесённых изменений.
        eeprom_write_dword((uint32_t *)EE_SAVED_CALBR, 0x60);         // Calibrated
        si5351.init(SI5351_CRYSTAL_LOAD_8PF, xt_freq, 0);                // Initialize
        si5351.set_pll(SI5351_PLL_FIXED, SI5351_PLLA);        
     //   si5351.set_freq(bfo_f * SI5351_FREQ_MULT, SI5351_CLK2);   // correct BFO frequency
  //        if (USBLSBflag == 0)
  //         si5351.set_freq((bfo_f * SI5351_FREQ_MULT), SI5351_CLK2); 
   //       else if (USBLSBflag == 1)
   //        si5351.set_freq((bfo_U * SI5351_FREQ_MULT), SI5351_CLK2);     
// Update Rx frequency    
//    if (USBLSBflag == 0 && vfo_t <= bfo_f) vfo_r = vfo_t + bfo_f;      // Upper / lower mixing  
//    else if (USBLSBflag == 0) vfo_r = vfo_t - bfo_f;
 //   else if (USBLSBflag == 1 && vfo_t <= bfo_U) vfo_r = vfo_t + bfo_U;
//    else if (USBLSBflag == 1) vfo_r = vfo_t - bfo_U;    
  //  si5351.set_freq((vfo_r * SI5351_FREQ_MULT), SI5351_CLK1);
 //   si5351.set_freq(vfo_t * SI5351_FREQ_MULT, SI5351_CLK0);   // Correct Tx freq
    //    if (vfo_t <= bfo_f) vfo_r = vfo_t + bfo_f;                                  // Upper / lower mixing
    //    else vfo_r = vfo_t - bfo_f;
    //      si5351.set_freq(vfo_r * SI5351_FREQ_MULT, SI5351_CLK1);   // correct Rx frequency
        eeprom_write_dword((uint32_t *)EE_SAVED_AFREQ, vfo_t);  //store VFO frequency into EEPROM.Must!!! save only!!!after calibrate!!!
        //Имел место сбой,иногда после калибровки и последующей перезагрузки(именно перезагрузки,НЕ отключения питания!)
        //,вместо стартовой частоты VFO взятой из EEPROM
        //загружалось значение,выставленное при калибровке(25.004230,для примера).
        //Теперь при калибровке(только!!! при калибровке)VFO сохраняется в EEPROM.
        //Случайно создал дополнительное удобство-если надо,то можно сохранить стартовую частоту.
           eeprom_write_dword((uint32_t *)EE_SAVED_BFREQ, bfo_f);  //Сохранение основного опорника BFO
           eeprom_write_dword((uint32_t *)EE_SAVED_UBFO, bfo_U);   //Сохранение добавленного опорника UBFO
           eeprom_write_dword((uint32_t *)EE_SAVED_RADIX, radix);   //
        //   eeprom_write_dword((uint32_t *)EE_SAVED_AFREQ, vfo_t);   //
           eeprom_write_dword((uint32_t *)EE_SAVED_MODE, USBLSBflag); //сохранение режима USB/LSB
           temp_volt_corr = eeprom_read_dword((const uint32_t *)EE_SAVED_VCOR);  //read correction for voltmeter
           if (temp_volt_corr != volt_corr);
           eeprom_write_dword((const uint32_t *)EE_SAVED_VCOR, volt_corr);  //save correction for voltmeter

           
           changed_f = 1;
           tooupdate = 1;
        void freq_update();
      }
    calflag = 0;
    }
  } 
            
    
  
     
     

     
  
     
    



if(millis() - time_oled_update > 200)
 {
  time_oled_update = millis();
  display_frequency();
     void pwr_update();

  {
    int rawpower = analogRead(mypowerpin);
  mypower = map(rawpower, 0, 1023, 0, 100);  
  display.setCursor(4, 55);
  display.print("PWR");

  display.setCursor(24, 55);
  //display.setTextColor(BLACK);
  display.print("-20-10-7-5-3 0+3");
  display.fillRect(24, 55, mypower, 9, WHITE);
 // display.setTextColor(WHITE);
  

 }

     if (UBFOflag == 1 && USBLSBflag == 0 && calibrate == 0 && act_clk == 0)   //Если кнопка USB_LSB нажата и USBLSBflag(признак выбора нужной боковой) =0
     
      {
        USBLSBflag = 1;                      //флаг признака установить в 1.Эта единица будет являться признаком USB
        display.setCursor(45, 25);           //задать координаты для надписи USB
      //  disp_txt = 0;
  display.print(F("USB"));                   //вывести надпись USB
 
  delay(20);
  modeflag = 0;                              //сообщить обработчику кнопок,что никакая кнопка не нажата
  UBFOflag = 0;                              //и на всякий случай сообщить,что кнопка USB_LSB тоже уже не нажата
  
        
      }
      else if (UBFOflag == 1 && USBLSBflag == 1 && calibrate == 0 && act_clk == 0)  //Иначе если кнопка USB_LSB нажата и USBLSBflag(признак выбора нужной боковой) =1
     {
      USBLSBflag = 0;                             //флаг признака установить в 0.Этот ноль будет являться признаком LSB
      display.setCursor(45, 25);
    //  disp_txt = 0;
  display.print(F("LSB"));

  delay(20);
  modeflag = 0;
  UBFOflag = 0;
     }
     else if (USBLSBflag == 1 && calibrate == 0 && act_clk == 0)                    //иначе если выбрана USB ничего не изменять
     {display.setCursor(45, 25);
      display.print(F("USB"));}                   //продолжать выводить USB
     
     else if (USBLSBflag == 0 && calibrate == 0 && act_clk == 0)                    //иначе если выбрана LSB ничего не изменять
    {display.setCursor(45, 25); 
     display.print(F("LSB"));}                    //продолжать выводить LSB


 if (calibrate == 0 && act_clk != 2 && act_clk != 3) //(25.01.2021 если не включена калибровка И режим лбфо и режим убфо то диапазоны отображаем.)
 {
 //160-метровый диапазон (1.81-2 МГц)
 if (vfo_t >= 1810000ULL && vfo_t <= 2000000ULL) //если частота в пределах диапазона 1.81-2 МГц
 {
  digitalWrite (BAND_160_OUT, HIGH);  //включаем пин управления ДПФ 160
  display.setCursor(12, 25);          //указываем координаты
  display.print(F("160m"));           //для надписи "160m"
  if (handflag == 0) USBLSBflag = 0;  //handflag - признак,что была использована ручная смена USB-LSB.Программа не будет принудительно менять режим под выбранный диапазон.
                                      //флаг сбрасывается после выхода за пределы любительского диапазона.
                                      //USBLSBflag - признак режима.LSB = 0,USB = 1.Можно поменять при сборке под свои нужды.
 }
 else
 //80-метровый диапазон (3.5-3.8 МГц)
 if (vfo_t >= 3500000ULL && vfo_t <= 3800000ULL)
 {
  digitalWrite (BAND_80_OUT, HIGH);   //включаем пин управления ДПФ 80
  display.setCursor(12, 25);
  display.print(F("80m"));
  if (handflag == 0) USBLSBflag = 0; //описание выше
 }
 else
 //40-метровый диапазон (7.0-7.2 МГц)
 if (vfo_t >= 7000000ULL && vfo_t <= 7200000ULL)
 {
  digitalWrite (BAND_40_OUT, HIGH);   //включаем пин управления ДПФ 40
  display.setCursor(12, 25);
  display.print(F("40m"));
  if (handflag == 0) USBLSBflag = 0; //описание выше
 }
 else
 //30-метровый диапазон (10.1-10.15 МГц)
 if (vfo_t >= 10100000ULL && vfo_t <= 10150000ULL)
 {
  display.setCursor(12, 25);
  display.print(F("30m"));
  if (handflag == 0) USBLSBflag = 0; //описание выше
 }
 else
 //20-метровый диапазон (14-14.35 МГц)
 if (vfo_t >= 14000000ULL && vfo_t <= 14350000ULL)
 {
  display.setCursor(12, 25);
  display.print(F("20m"));
  if (handflag == 0) USBLSBflag = 1; //описание выше
 }
 else
 //17-метровый диапазон (18.068-18.168 МГц)
 if (vfo_t >= 18068000ULL && vfo_t <= 18168000ULL)
 {
  display.setCursor(12, 25);
  display.print(F("17m"));
  if (handflag == 0) USBLSBflag = 1; //описание выше
 }
 else
 //15-метровый диапазон (21-21.45 МГц)
 if (vfo_t >= 21000000ULL && vfo_t <= 21450000ULL)
 {
  display.setCursor(12, 25);
  display.print(F("15m"));
  if (handflag == 0) USBLSBflag = 1; //описание выше
 }
 else
 //12-метровый диапазон (24.89-25.14 МГц)
 if (vfo_t >= 24890000ULL && vfo_t <= 25140000ULL)
 {
  display.setCursor(12, 25);
  display.print(F("12m"));
  if (handflag == 0) USBLSBflag = 1; //описание выше
 }
 else
 //10-метровый диапазон (28-29.7 МГц)
 if (vfo_t >= 28000000ULL && vfo_t <= 29700000ULL)
 {
  display.setCursor(12, 25);
  display.print(F("10m"));
  if (handflag == 0) USBLSBflag = 1; //описание выше
 }
 else  //иначе,если частота не совпадает ни с одним диапазоном для включения ДПФ

 {
  
  digitalWrite (BAND_160_OUT, LOW);  //выключаем ДПФ 160
  digitalWrite (BAND_80_OUT, LOW);   //выключаем ДПФ 80
  digitalWrite (BAND_40_OUT, LOW);   //выключаем ДПФ 40
  display.setCursor(12, 25);
  //disp_txt = 0;                      //clear a row (25.01.2021)
  display.print(F("RADIO"));         //пишем на дисплее РАДИО,как принадлежность к вещательным диапазонам
  handflag = 0;                      //сбрасываем флаг признака ручного переключения режимов USB-LSB.В режиме радио программа не пытается переключить режим.Только вручную,по желанию.
 }
 }
}

//  int rawpower = analogRead(mypowerpin);
//  mypower = map(rawpower, 0, 1023, 0, 100);


  if(millis() - time_volt_update > 200)
 {
  time_volt_update = millis();
 
   //  void volt_update();
     void volt_update(); //
 { int rawbatt = analogRead(mybattpin);  //читаем из контакта вольтметра в переменную сырых данных равбатт
  mybatt = (map(rawbatt, 0, 1023, 0, volt_corr)); //преобразовываем 1023 отсчёта в 1000 и пишем в майбатт-это уже напруга в целом числе
unsigned long volt; //заводим переменную для копирования из майбатт в вольт-для форматированного вывода
if (mybatt <= 10) mybatt = 15;
volt = mybatt;                               //копируем из майбатт в вольт

//  display.setCursor(70, 25); //координаты дисплея для отображения шага частоты 
//  display.setTextSize(1);  
//  display.print(mybatt);
//  display.setCursor(95, 25);
//  display.print(F("v"));

// void voltmeter();
//{// display.display();
  display.setTextSize(1);  //размер текста для вывода вольтметра
  char VOLTstr[12];        //массив для форматированного вывода
  char vvv[5], mvv[12];    //вольты и миливольты соответственно
  int m,n;                 //временные переменные для форматирования
//  unsigned long volt;
 // display.clearDisplay();

 
    
  mvv[1]='\0';                           // empty arry

  sprintf(VOLTstr, "%ld", volt);           // convert volt to string
  m=strlen(VOLTstr);  // determine length

  strncpy(vvv,VOLTstr,(m-2));              // get volt digits (1-2)
  n=m-1;
  vvv[n]='\0';                            // end with null character
  strcpy(mvv,VOLTstr);                    // get milivolt digits (2)
  strcpy(VOLTstr+n,mvv+(n-1));            // copy into VOLTstr
  VOLTstr[n]='.';                          // decimal point

  display.setCursor(95, 25);               //set cursor to display voltmeter
  display.println(VOLTstr);                //print to display voltmeter
//  display_settings();
  display.setCursor(120, 25);
  display.print(F("v"));
//}

  
  }}
 
//  void pwr_update();
  //{
//  display.setCursor(15, 55);
//  display.print("PWR");
 // display.setTextColor(BLACK);
//  display.setCursor(35, 55);
//  display.print("-20-10-7-5-3 0");
//  display.fillRect(35, 55, mypower, 9, WHITE);
 // display.setTextColor(WHITE);
  

  
  


 
} // end while loop

