;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Bit reverse the number
; Change 11100000b to 00000111b or vice-versa
;--------------------------------------------
permute proc    uses edx, index:DWORD       ;
LOCAL   result:DWORD                        ;
        mov     edx, index                  ;
        mov     eax, samples                ;
        mov     result, 0                   ;
        .while eax != 1                     ;
            shr     eax, 1                  ;
            shr     edx, 1                  ;
            .if CARRY?                      ;
                add     result, eax         ;
            .endif                          ;
        .endw                               ;
        mov     eax, result                 ;
        ret                                 ;
permute endp                                ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Calculate Power Magnitude
;--------------------------------------------
magnitude   proc    uses esi, iDD:DWORD     ;
        ;====================================
        ; n = permute(n)
        ; return (sqrt(real[n] * real[n] + imag[n] * imag[n]))
        ;------------------------------------
        invoke  permute, iDD                ; eax = permute(iDD)
        lea     esi, realBuff               ;
        fld     qword ptr[esi+eax*8]        ; ⠥  ᨢ
        fmul    qword ptr[esi+eax*8]        ; real[n] * real[n]

        lea     esi, imagBuff               ;
        fld     qword ptr[esi+eax*8]        ; ⠥  ᨢ
        fmul    qword ptr[esi+eax*8]        ; imag[n] * imag[n]
        fadd                                ; st(1) = st + st(1), & pop
        fsqrt                               ; sqrt(real[n]*real[n] + imag[n]*imag[n])
        fstp    mag                         ; store & pop
        ret                                 ;
magnitude   endp                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Find maximum amplitude
;--------------------------------------------
max_amp proc                                ;
        ;====================================
        ; max = (double)0.0
        ; for (loop = 0; loop < samples; loop++)
        ;     if ((mag = magnitude(loop)) > max)
        ;           max = mag
        ;------------------------------------
        fldz                                ;
        fst     max                         ; max = (double)0.0
        mov     ebx, samples                ;
        shr     ebx, 1                      ; samples/2
        mov     ecx, 1                      ;
        .while ecx < ebx                    ;
            invoke  magnitude, ecx          ;
            fld     mag                     ;
            fcom    max                     ; (mag - max)
            fstsw   ax                      ; ah = 䫠
            .if !(ah & 1)                   ; !CARRY?
                fstp    max                 ; 襬  祭
            .else                           ;
                fstp    mag                 ;
            .endif                          ;
            inc     ecx                     ;
        .endw                               ;
        ret                                 ;
max_amp endp                                ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Fast Furie Transformation
;--------------------------------------------
fft     proc    uses esi edi                ;
LOCAL   i1:DWORD, i2, i3, i4, iy            ;
LOCAL   qa1:QWORD, qa2, qb1, qb2, qz1, qz2, qv
        ;====================================
        ; i1 = samples >> 1
        ; i2 = 1
        ;------------------------------------
        m2m     i1, samples                 ;
        shr     i1, 1                       ; i1 = samples >> 1
        mov     i2, 1                       ; i2 = 1
        ;====================================
        ; v = TWO_PI * ((double)1.0 / (double)samples)
        ;------------------------------------
        fld     TWO_PI                      ; 2pi
        fidiv   samples                     ; /samples
        fstp    qv                          ; v = 2pi/samples
        ;====================================
        ; for (loop = 0; loop < power; loop++)
        ;       i3 = 0
        ;       i4 = i1
        ;------------------------------------
        xor     ecx, ecx                    ;
        .while ecx < power                  ; 砫 0 横
            push    ecx                     ; <
            mov     i3, 0                   ; i3 = 0
            m2m     i4, i1                  ; i4 = samples/2
            ;================================
            ; for (loop1 = 0; loop1 < i2; loop1++)
            ;--------------------------------
            xor     ecx, ecx                ;
            .while ecx < i2                 ; 砫 1 横
                push    ecx                 ; <<
                ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                ; y = permute(i3 / i1)
                ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                xor     edx, edx            ;
                mov     eax, i3             ;
                div     i1                  ; i3 / i1
                invoke  permute, eax        ; eax = i3 / i1
                mov     iy, eax             ; y = permute(i3 / i1)
                ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                ; z1 =  cos(v * y)
                ; z2 = -sin(v * y)
                ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                fld     qv                  ;
                fimul   iy                  ; = (v * y)
                fcos                        ;
                fstp    qz1                 ; z1 =  cos(v * y)
                fld     qv                  ;
                fimul   iy                  ; = (v * y)
                fsin                        ;
                fchs                        ; 塞 
                fstp    qz2                 ; z2 = -sin(v * y)
                ;============================
                ; for (loop2 = i3; loop2 < i4; loop2++)
                ;----------------------------
                mov     ecx, i3             ;
                .while ecx < i4             ; 砫 2 横
                    push    ecx             ; <<<
                    ;~~~~~~~~~~~~~~~~~~~~~~~~
                    ; a1 = real[loop2]
                    ; a2 = imag[loop2]
                    ;~~~~~~~~~~~~~~~~~~~~~~~~
                    lea     esi, realBuff   ;
                    fld     qword ptr[esi+ecx*8]
                    fstp    qa1             ; a1 = real[loop2]
                    lea     esi, imagBuff   ;
                    fld     qword ptr[esi+ecx*8]
                    fstp    qa2             ; a2 = imag[loop2]
                    ;~~~~~~~~~~~~~~~~~~~~~~~~
                    ; b1 = z1*real[loop2+i1] - z2*imag[loop2+i1]
                    ; b2 = z2*real[loop2+i1] + z1*imag[loop2+i1]
                    ;~~~~~~~~~~~~~~~~~~~~~~~~
                    mov     eax, ecx        ;
                    add     eax, i1         ;
                    lea     esi, realBuff   ;
                    fld     qword ptr[esi+eax*8]
                    fmul    qz1             ; z1*real[loop2+i1]
                    lea     esi, imagBuff   ;
                    fld     qword ptr[esi+eax*8]
                    fmul    qz2             ; z2*imag[loop2+i1]
                    fsubp   st(1), st       ; st(1) = st(1) - st, & pop
                    fstp    qb1             ; b1 = z1*real[loop2+i1] - z2*imag[loop2+i1]

                    lea     esi, realBuff   ;
                    fld     qword ptr[esi+eax*8]
                    fmul    qz2             ; z2*real[loop2+i1]
                    lea     esi, imagBuff   ;
                    fld     qword ptr[esi+eax*8]
                    fmul    qz1             ; z1*imag[loop2+i1]
                    faddp   st(1), st       ; st(1) = st(1) + st, & pop
                    fstp    qb2             ; b2 = z2*real[loop2+i1] + z1*imag[loop2+i1]
                    ;~~~~~~~~~~~~~~~~~~~~~~~~
                    ; real[loop2] = a1 + b1
                    ; imag[loop2] = a2 + b2
                    ;~~~~~~~~~~~~~~~~~~~~~~~~
                    fld     qa1             ;
                    fadd    qb1             ;
                    lea     esi, realBuff   ;
                    fstp    qword ptr[esi+ecx*8]
                    fld     qa2             ;
                    fadd    qb2             ;
                    lea     esi, imagBuff   ;
                    fstp    qword ptr[esi+ecx*8]
                    ;~~~~~~~~~~~~~~~~~~~~~~~~
                    ; real[loop2 + i1] = a1 - b1
                    ; imag[loop2 + i1] = a2 - b2
                    ;~~~~~~~~~~~~~~~~~~~~~~~~
                    fld     qa1             ;
                    fsub    qb1             ;
                    lea     esi, realBuff   ;
                    fstp    qword ptr[esi+eax*8]
                    fld     qa2             ;
                    fsub    qb2             ;
                    lea     esi, imagBuff   ;
                    fstp    qword ptr[esi+eax*8]

                    pop     ecx             ; >>>
                    inc     ecx             ;
                .endw                       ;  2 横
                ; i3 += (i1 << 1)
                ; i4 += (i1 << 1)
                mov     eax, i1             ;
                shl     eax, 1              ;
                add     i3, eax             ;
                add     i4, eax             ;

                pop     ecx                 ; >>
                inc     ecx                 ;
            .endw                           ;  1 横
            ; i1 >>= 1
            ; i2 <<= 1
            shr     i1, 1                   ;
            shl     i2, 1                   ;

            pop     ecx                     ; >
            inc     ecx                     ;
        .endw                               ;  0 横
        ret                                 ;
fft     endp                                ;
