//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
// PSK31Core Library for transmission and reception of PSK31 signals
//    using a PC soundcard  or .wav files.
//	               Copyright 2000, Moe Wheatley, AE4JY
//
//This library is free software; you can redistribute it and/or
//modify it under the terms of the GNU Lesser General Public
//License as published by the Free Software Foundation; either
//version 2.1 of the License, or (at your option) any later version.
//
//This library is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//Lesser General Public License for more details.
//
//You should have received a copy of the GNU Lesser General Public
//License along with this library; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// http://www.gnu.org/copyleft/lesser.html
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
#if !defined(AFX_PSKDETTBL_H__0A83B9C2_549A_11D2_A141_00A0C996E7F5__INCLUDED_)
#define AFX_PSKDETTBL_H__0A83B9C2_549A_11D2_A141_00A0C996E7F5__INCLUDED_

#include "math.h"
//
#define PI2 ( 8.0 * atan(1.0) )		// 2 Pi
//


#define DEC4_LPFIR_LENGTH 35
//  Design method: Parks-McClellan method
//  Number of taps  =  35
//  Number of bands =  2 
//  Band     Lower       Upper       Value      Weight
//            edge        edge
//   1         0.0       .0125         1.0         1
//   2         .125      .5          .000001       10  
const double Dec4LPCoef[DEC4_LPFIR_LENGTH*2 ] = {
 -0.00021203644,
 -0.00070252426,
  -0.0016680526,
  -0.0031934799,
  -0.0051899752,
  -0.0072862086,
  -0.0087714235,
  -0.0086272102,
  -0.0056735648,
   0.0011784719,
     0.01261353,
    0.028615709,
    0.048280707,
    0.069812051,
    0.090735013,
     0.10830381,
     0.12001897,
     0.12413413,
     0.12001897,
     0.10830381,
    0.090735013,
    0.069812051,
    0.048280707,
    0.028615709,
     0.01261353,
   0.0011784719,
  -0.0056735648,
  -0.0086272102,
  -0.0087714235,
  -0.0072862086,
  -0.0051899752,
  -0.0031934799,
  -0.0016680526,
 -0.00070252426,
 -0.00021203644,
//
 -0.00021203644,
 -0.00070252426,
  -0.0016680526,
  -0.0031934799,
  -0.0051899752,
  -0.0072862086,
  -0.0087714235,
  -0.0086272102,
  -0.0056735648,
   0.0011784719,
     0.01261353,
    0.028615709,
    0.048280707,
    0.069812051,
    0.090735013,
     0.10830381,
     0.12001897,
     0.12413413,
     0.12001897,
     0.10830381,
    0.090735013,
    0.069812051,
    0.048280707,
    0.028615709,
     0.01261353,
   0.0011784719,
  -0.0056735648,
  -0.0086272102,
  -0.0087714235,
  -0.0072862086,
  -0.0051899752,
  -0.0031934799,
  -0.0016680526,
 -0.00070252426,
 -0.00021203644
};

//  Filter type:   Multiband filter
//  Design method: Parks-McClellan method
//  Number of taps  =  65
//  Number of bands =  2 
//  Band   Lower       Upper       Value      Weight
//         edge        edge
//
//	1       0.0        .03125         1.         1.
//	2        .0625     .5          .0000       286.
#define BITFIR_LENGTH 65
const double BitFirCoef[BITFIR_LENGTH*2] = { // 16 Hz bw LP filter for data recovery
 4.3453566e-005,
 -0.00049122414,
 -0.00078771292,
  -0.0013507826,
  -0.0021287814,
   -0.003133466,
   -0.004366817,
  -0.0058112187,
  -0.0074249976,
  -0.0091398882,
   -0.010860157,
   -0.012464086,
   -0.013807772,
   -0.014731191,
   -0.015067057,
   -0.014650894,
   -0.013333425,
    -0.01099166,
  -0.0075431246,
  -0.0029527849,
   0.0027546292,
   0.0094932775,
    0.017113308,
    0.025403511,
    0.034099681,
    0.042895839,
    0.051458575,
    0.059444853,
    0.066521003,
    0.072381617,
    0.076767694,
    0.079481619,
    0.080420311,
    0.079481619,
    0.076767694,
    0.072381617,
    0.066521003,
    0.059444853,
    0.051458575,
    0.042895839,
    0.034099681,
    0.025403511,
    0.017113308,
   0.0094932775,
   0.0027546292,
  -0.0029527849,
  -0.0075431246,
    -0.01099166,
   -0.013333425,
   -0.014650894,
   -0.015067057,
   -0.014731191,
   -0.013807772,
   -0.012464086,
   -0.010860157,
  -0.0091398882,
  -0.0074249976,
  -0.0058112187,
   -0.004366817,
   -0.003133466,
  -0.0021287814,
  -0.0013507826,
 -0.00078771292,
 -0.00049122414,
 4.3453566e-005,
//
 4.3453566e-005,
 -0.00049122414,
 -0.00078771292,
  -0.0013507826,
  -0.0021287814,
   -0.003133466,
   -0.004366817,
  -0.0058112187,
  -0.0074249976,
  -0.0091398882,
   -0.010860157,
   -0.012464086,
   -0.013807772,
   -0.014731191,
   -0.015067057,
   -0.014650894,
   -0.013333425,
    -0.01099166,
  -0.0075431246,
  -0.0029527849,
   0.0027546292,
   0.0094932775,
    0.017113308,
    0.025403511,
    0.034099681,
    0.042895839,
    0.051458575,
    0.059444853,
    0.066521003,
    0.072381617,
    0.076767694,
    0.079481619,
    0.080420311,
    0.079481619,
    0.076767694,
    0.072381617,
    0.066521003,
    0.059444853,
    0.051458575,
    0.042895839,
    0.034099681,
    0.025403511,
    0.017113308,
   0.0094932775,
   0.0027546292,
  -0.0029527849,
  -0.0075431246,
    -0.01099166,
   -0.013333425,
   -0.014650894,
   -0.015067057,
   -0.014731191,
   -0.013807772,
   -0.012464086,
   -0.010860157,
  -0.0091398882,
  -0.0074249976,
  -0.0058112187,
   -0.004366817,
   -0.003133466,
  -0.0021287814,
  -0.0013507826,
 -0.00078771292,
 -0.00049122414,
 4.3453566e-005
};


//  Filter type:   Multiband filter
//  Design method: Parks-McClellan method
//  Number of taps  =  65 
//  Number of bands =  2 
//  Band   Lower       Upper       Value      Weight
//         edge        edge
//
//	1       0.0        .049          1.         1.
//	2        .08575    .5          .00002      40.
const double FreqFirCoef[BITFIR_LENGTH*2] = { // 31.25 Hz bw LP filter for frequency error
 -0.00088229088,
  -0.0011374389,
  -0.0016412868,
  -0.0020520989,
  -0.0022175618,
  -0.0019791161,
  -0.0012057952,
  0.00016527251,
   0.0020943472,
   0.0044122668,
   0.0068189371,
   0.0089045933,
    0.010203678,
    0.010266316,
   0.0087507451,
   0.0055136683,
  0.00068616242,
   -0.005288313,
   -0.011653249,
   -0.017399749,
   -0.021376642,
   -0.022435377,
   -0.019606873,
   -0.012263665,
 -0.00026078671,
    0.015986088,
    0.035491391,
    0.056773305,
    0.078002392,
    0.097207364,
     0.11251413,
     0.12237776,
     0.12580366,
     0.12237776,
     0.11251413,
    0.097207364,
    0.078002392,
    0.056773305,
    0.035491391,
    0.015986088,
 -0.00026078671,
   -0.012263665,
   -0.019606873,
   -0.022435377,
   -0.021376642,
   -0.017399749,
   -0.011653249,
   -0.005288313,
  0.00068616242,
   0.0055136683,
   0.0087507451,
    0.010266316,
    0.010203678,
   0.0089045933,
   0.0068189371,
   0.0044122668,
   0.0020943472,
  0.00016527251,
  -0.0012057952,
  -0.0019791161,
  -0.0022175618,
  -0.0020520989,
  -0.0016412868,
  -0.0011374389,
 -0.00088229088,
//
 -0.00088229088,
  -0.0011374389,
  -0.0016412868,
  -0.0020520989,
  -0.0022175618,
  -0.0019791161,
  -0.0012057952,
  0.00016527251,
   0.0020943472,
   0.0044122668,
   0.0068189371,
   0.0089045933,
    0.010203678,
    0.010266316,
   0.0087507451,
   0.0055136683,
  0.00068616242,
   -0.005288313,
   -0.011653249,
   -0.017399749,
   -0.021376642,
   -0.022435377,
   -0.019606873,
   -0.012263665,
 -0.00026078671,
    0.015986088,
    0.035491391,
    0.056773305,
    0.078002392,
    0.097207364,
     0.11251413,
     0.12237776,
     0.12580366,
     0.12237776,
     0.11251413,
    0.097207364,
    0.078002392,
    0.056773305,
    0.035491391,
    0.015986088,
 -0.00026078671,
   -0.012263665,
   -0.019606873,
   -0.022435377,
   -0.021376642,
   -0.017399749,
   -0.011653249,
   -0.005288313,
  0.00068616242,
   0.0055136683,
   0.0087507451,
    0.010266316,
    0.010203678,
   0.0089045933,
   0.0068189371,
   0.0044122668,
   0.0020943472,
  0.00016527251,
  -0.0012057952,
  -0.0019791161,
  -0.0022175618,
  -0.0020520989,
  -0.0016412868,
  -0.0011374389,
 -0.00088229088
};


// phase wraparound correction tables for viterbi decoder
const double ANGLE_TBL1[4] = { 3.0*PI2/4.0, 0.0, PI2/4.0, PI2/2.0};
const double ANGLE_TBL2[4] = { 3.0*PI2/4.0, PI2, PI2/4.0, PI2/2.0 };

// bit sync half distance table
// index any position 0 to 15 and it returns a position halfway from the index
const INT HALF_TBL[16] = {
    7,	// 0
   8,	// 1
   9,	// 2
   10,	// 3
   11,	// 4
   12,	// 5
   13,	// 6
   14,	// 7
    0,	// 8
    1,	// 9
    2,	// 10
    3,	// 11
    4,	// 12
    5,	// 13
    6,	// 14
    7,	// 15
};

#endif // !defined(AFX_PSKDETTBL_H__0A83B9C2_549A_11D2_A141_00A0C996E7F5__INCLUDED_)
