unit lars3_p;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, mmsystem, ExtCtrls, math, ffts, types, complexs, Spin;

const
  BufferCount    = 8;
  WaveFrequency  = 11025;
  WaveResolution = 16;

  c_bpf=16;
  c_lpf=16;
  sec_1=11025;
  Buf_Size=1024;
  Buf_Len=buf_size*2;

  WaveFormat: TWaveFormatEx=(
    wFormatTag	           : WAVE_FORMAT_PCM;
    nChannels	           : 1;
    nSamplesPerSec     	   : 11025;
    nAvgBytesPerSec	   : 22050;
    nBlockAlign            : 1;
    wBitsPerSample	   : 16;
    cbSize		   : 0) ;

type
    TWaveHeader   = Record
       RIFF       : dword;
       ChunkLen   : integer;
       WAVE       : dword;
       fmt        : dword;
       FormatLen  : integer;
       Format     : word;
       Channels   : word;
       Frequency  : integer;
       BytesPS    : integer;
       BlockAlign : word;
       BitsPS     : word;
       data       : dword;
       DataLen    : integer
    End;
    TData16 = array [0..11024] of smallint;
    PData16 = ^TData16;
    TForm1 = class(TForm)
    PaintBox2: TPaintBox;
    RichEdit1: TRichEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
    pWaveBuffer : array [0..buffercount-1] of lpstr;
    pWaveHeader : array [0..buffercount-1] of PWAVEHDR;
    hWaveHeader : array [0..buffercount-1] of THANDLE;
    hWaveBuffer : array [0..buffercount-1] of THANDLE;
    hWaveFmtEx : THANDLE;
    Procedure BufferFull (var Msg:TMessage); Message MM_WIM_DATA;
    Procedure StartRecording;
    Procedure StopRecording;
  public
    { Public declarations }
    fft_buf,fft_disp: array[0..2047] of smallint;
    data1: PData16;
    procedure init_BPF(p1,p2: word);
    procedure init_LPF;
    procedure decode;
    procedure disp2;
    procedure pointer;
  end;


var
  Form1: TForm1;

implementation

{$R *.DFM}

var
  BaferaSize      : integer;
  Recording       : Boolean;
  WaveHeader      : TWaveHeader;
  pWaveFmtEx      : PWaveFormatEx;
  WaveInHandle    : hWaveIn;
  WaveIn: hWaveIn;
  WaveOut: hWaveOut;
  DeviceId : DWord;

  i: word;
  n,n1: word;
  c,c1,bit,bit1,last_bit,last_bit1: char;
  T_bits: byte=0;
  freq,shft,baud,_baud: word;
  bit_0,bit_1: word;
  bytes,last_bits,last_bits2: string;
  rx_bit,rx_sym,quit,full: boolean;
  _full_baud_buf,_full_fft_buf,_quit: boolean;
  meandr,lpf,_baud_buf,baud_buf: array[0..buf_size+c_bpf+c_lpf-1] of single;
  fir_bpf: array[0..1,0..c_bpf-1] of single;
  fir_lpf: array[0..c_lpf-1] of single;
  fft_s,fft_d: array[0..2047] of TComplex;
  addr: string;

procedure TForm1.init_BPF(p1,p2: word);
var
  i: word;
  f1,f2: single;
begin
  for i:=0 to c_bpf-1 do
  begin
    f1:=(2*c_bpf/sec_1)*pi*(p1+p2/2)*(i/c_bpf);
    f2:=(2*c_bpf/sec_1)*pi*(p1-p2/2)*(i/c_bpf);
    fir_bpf[0,i]:=sin(f1);
    fir_bpf[1,i]:=sin(f2);
  end;
end;

procedure TForm1.init_LPF;
var
  i: word;
  f1,f2: single;
begin
  for i:=0 to c_lpf-1 do
  begin
    f1:=(2*c_lpf/sec_1)*pi*(i/c_lpf);
    fir_lpf[i]:=sin(f1);
  end;
end;

function bin2hex(p1: string): string;
var
  i: byte;
begin
  i:=0;
  if p1[4]='1' then i:=i+8;
  if p1[3]='1' then i:=i+4;
  if p1[2]='1' then i:=i+2;
  if p1[1]='1' then i:=i+1;
  if i<10 then bin2hex:=inttostr(i) else bin2hex:=chr(i+55);
end;

procedure TForm1.decode;
var
  k,i,ii,len: word;
  acc,acc1: single;
  s: string;
begin
  //      
  for i:=0 to buf_size-1 do
  begin
    acc:=0; acc1:=0;
    for k:=0 to c_bpf-1 do
    begin
      acc:=acc+baud_buf[i+k]*fir_bpf[0,k];
      acc1:=acc1+baud_buf[i+k]*fir_bpf[1,k];
    end;
    lpf[i+c_lpf]:=abs(acc)-abs(acc1);
  end;
  for i:=0 to c_bpf-1 do baud_buf[i]:=baud_buf[i+buf_size];
  //     
  for i:=0 to buf_size-1 do
  begin
    acc:=0;
    for k:=0 to c_lpf-1 do acc:=acc+lpf[i+k]*fir_lpf[k];
    meandr[i]:=acc;
  end;
  for i:=0 to c_lpf-1 do lpf[i]:=lpf[i+buf_size];
  //
  for i:=0 to buf_size-1 do
  begin
    if meandr[i]>0 then bit:='1' else bit:='0';
    if last_bit=bit then inc(n);
    if n>=_baud div 2 then rx_bit:=true;
    if (n>=_baud) or (bit<>last_bit) then
    begin
      bit1:=last_bit;
      if rx_bit then
      begin
        if last_bit1=bit1 then inc(t_bits);
        if t_bits>3 then t_bits:=4;
        if last_bit1<>bit1 then
        begin
          case t_bits of
            1: bytes:=bytes+'0';
            2: bytes:=bytes+'1';
            4:
              begin
                if length(bytes)>31 then
                begin
                  addr:='';
                  addr:=addr+bin2hex(copy(bytes,8,3));
                  addr:=addr+bin2hex(copy(bytes,5,3));
                  addr:=addr+bin2hex(copy(bytes,2,3));
                  addr:=addr+bin2hex(copy(bytes,13,3));
                  addr:=addr+'-';
                  addr:=addr+bin2hex(copy(bytes,21,4));
                  addr:=addr+bin2hex(copy(bytes,17,4));
                  richedit1.lines.add(bytes+' : '+addr);
                end;
                bytes:='';
              end;
          end;
          t_bits:=1;
        end;
        last_bit1:=bit1;
      end;
      n:=0; rx_bit:=false;
    end;
    last_bit:=bit;
  end;
end;

Procedure CheckError (ErrorCode:dword);
Var ErrorText : string;
Begin
  Case ErrorCode of
  MMSYSERR_NOERROR         : Exit;
  MMSYSERR_ERROR           : ErrorText:='MMSYSERR_ERROR';
  MMSYSERR_BADDEVICEID     : ErrorText:='MMSYSERR_BADDEVICEID';
  MMSYSERR_NOTENABLED      : ErrorText:='MMSYSERR_NOTENABLED';
  MMSYSERR_ALLOCATED       : ErrorText:='MMSYSERR_ALLOCATED';
  MMSYSERR_INVALHANDLE     : ErrorText:='MMSYSERR_INVALHANDLE';
  MMSYSERR_NODRIVER        : ErrorText:='MMSYSERR_NODRIVER';
  MMSYSERR_NOMEM           : ErrorText:='MMSYSERR_NOMEM';
  MMSYSERR_NOTSUPPORTED    : ErrorText:='MMSYSERR_NOTSUPPORTED';
  MMSYSERR_BADERRNUM       : ErrorText:='MMSYSERR_BADERRNUM';
  MMSYSERR_INVALFLAG       : ErrorText:='MMSYSERR_INVALFLAG';
  MMSYSERR_INVALPARAM      : ErrorText:='MMSYSERR_INVALPARAM';
  MMSYSERR_HANDLEBUSY      : ErrorText:='MMSYSERR_HANDLEBUSY';
  WAVERR_BADFORMAT         : ErrorText:='WAVERR_BADFORMAT';
  WAVERR_STILLPLAYING      : ErrorText:='WAVERR_STILLPLAYING';
  WAVERR_UNPREPARED        : ErrorText:='WAVERR_UNPREPARED';
  WAVERR_SYNC              : ErrorText:='WAVERR_SYNC';
  MMIOERR_FILENOTFOUND     : ErrorText:='MMIOERR_FILENOTFOUND';
  MMIOERR_OUTOFMEMORY      : ErrorText:='MMIOERR_OUTOFMEMORY';
  MMIOERR_CANNOTOPEN       : ErrorText:='MMIOERR_CANNOTOPEN';
  MMIOERR_CANNOTCLOSE      : ErrorText:='MMIOERR_CANNOTCLOSE';
  MMIOERR_CANNOTREAD       : ErrorText:='MMIOERR_CANNOTREAD';
  MMIOERR_CANNOTWRITE      : ErrorText:='MMIOERR_CANNOTWRITE';
  MMIOERR_CANNOTSEEK       : ErrorText:='MMIOERR_CANNOTSEEK';
  MMIOERR_CANNOTEXPAND     : ErrorText:='MMIOERR_CANNOTEXPAND';
  MMIOERR_CHUNKNOTFOUND    : ErrorText:='MMIOERR_CHUNKNOTFOUND';
  MMIOERR_UNBUFFERED       : ErrorText:='MMIOERR_UNBUFFERED';
  MMIOERR_PATHNOTFOUND     : ErrorText:='MMIOERR_PATHNOTFOUND';
  MMIOERR_ACCESSDENIED     : ErrorText:='MMIOERR_ACCESSDENIED';
  MMIOERR_SHARINGVIOLATION : ErrorText:='MMIOERR_SHARINGVIOLATION';
  MMIOERR_NETWORKERROR     : ErrorText:='MMIOERR_NETWORKERROR';
  MMIOERR_TOOMANYOPENFILES : ErrorText:='MMIOERR_TOOMANYOPENFILES';
  MMIOERR_INVALIDFILE      : ErrorText:='MMIOERR_INVALIDFILE';
  else                       ErrorText:='Unknown error: '+IntToStr (ErrorCode);
  End;
  ShowMessage ('Error: '+ErrorText);
  Application.Terminate
End;

Procedure TForm1.StartRecording;
Var I : integer;
Begin
  With WaveHeader do
  Begin
    RIFF:=mmioStringToFOURCC ('RIFF',0);
    WAVE:=mmioStringToFOURCC ('WAVE',0);
    fmt:=mmioStringToFOURCC ('fmt ',0);
    FormatLen:=16;
    Format:=1;
    Channels:=1;
    Frequency:=WaveFrequency;
    BytesPS:=Channels*WaveFrequency*(WaveResolution div 8);
    BlockAlign:=Channels*(WaveResolution div 8);
    BitsPS:=Channels*WaveResolution;
    data:=mmioStringToFOURCC ('data',0)
  End;
  hWaveFmtEx := GlobalAlloc(GMEM_MOVEABLE, SizeOf(TWaveFormatEx));
  pWaveFmtEx := PWaveFormatEx(GlobalLock(hWaveFmtEx));
  With pWaveFmtEx^ do
  Begin
    wFormatTag:=WAVE_FORMAT_PCM;
    nChannels:=1;
    nSamplesPerSec:=WaveFrequency;
    nAvgBytesPerSec:=nChannels*nSamplesPerSec*(WaveResolution div 8);
    nBlockAlign:=nChannels*(WaveResolution div 8);
    wBitsPerSample:=WaveResolution;
    cbSize:=0
  End;
  CheckError (waveInOpen (@WaveInHandle,WAVE_MAPPER,PWaveFormatEx(PWaveFmtEx),integer (Self.Handle),0,CALLBACK_WINDOW));
  With PWaveFmtEx^ do BaferaSize:=buf_size*nBlockAlign;
  For I:=0 to BufferCount-1 do
  Begin
    hWaveBuffer[i] := GlobalAlloc( GMEM_MOVEABLE or GMEM_SHARE, BaferaSize );
    hwaveheader[i] := GlobalAlloc( GMEM_MOVEABLE or GMEM_SHARE or GMEM_ZEROINIT, sizeof(TWAVEHDR));
    pWaveBuffer[i] := GlobalLock(hWaveBuffer[i]);
    pwaveheader[i] := GlobalLock (hwaveheader[i]);
    with pWaveHeader[i]^ do
    begin
      lpData := pWaveBuffer[i];      //   waveform
      dwBufferLength := BaferaSize;  // ,  , 
      dwBytesRecorded := 0;          //  
      dwUser := 0;                   // 32   
      dwFlags := 0;                  //  
      dwLoops := 0;                  //  
      lpNext := nil;                 // ;   
      reserved := 0;                 // ;   
    end;
    CheckError (waveInPrepareHeader (WaveInHandle,pwaveheader[i],SizeOf (TWaveHdr)))
  End;
  For I:=0 to BufferCount-1 do CheckError (waveInAddBuffer (WaveInHandle,pwaveheader[i],SizeOf (TWaveHdr)));
  Recording:=True;
  CheckError (waveInStart(WaveInHandle));
End;

Procedure TForm1.StopRecording;
Var I : integer;
Begin
   CheckError (waveInStop (WaveInHandle));
   Application.ProcessMessages;
   CheckError (waveInReset (WaveInHandle));
   For I:=0 to BufferCount-1 do
   Begin
     CheckError (waveInUnPrepareHeader (WaveInHandle,pwaveheader[i],SizeOf (TWaveHdr)));
     GlobalUnlock(hwaveheader[i]);
     GlobalFree(hwaveheader[i]);
     hWaveHeader[i] := 0;
     GlobalUnlock( hWaveBuffer[i] );
     GlobalFree( hWaveBuffer[i] );
     hWaveBuffer[i] := 0;
     pWaveBuffer[i] := nil;
   End;
   GlobalUnlock(hWaveFmtEx);
   GlobalFree(hWaveFmtEx);
   pWaveFmtEx := nil;
   CheckError (waveInClose (WaveInHandle));
   Recording:=False
End;

function hamming(p1: single): single;
begin
  hamming:=0.54-0.46*cos(2*pi*p1/(buf_len+1));
end;

function papoulis(p1: single): single;
begin
  papoulis:=sin(p1*pi/(buf_len+1));
end;

Procedure TForm1.BufferFull (var Msg:TMessage);
var
  WaveHdr : TWaveHdr;
  i: word;
Begin
  If not Recording then Exit;
  WaveHdr:=PWaveHdr (Msg.LParam)^;
  With WaveHdr do If dwBytesRecorded>0 then
  Begin
    data1:=pdata16(WaveHdr.lpdata);
    for i:=0 to buf_size-1 do
    begin
      fft_buf[i]:=fft_buf[i+buf_size];
      fft_buf[i+buf_size]:=data1[i];
      baud_buf[i+c_bpf]:=data1[i];
    end;
    decode;
    pointer;
    disp2;
  end;
  CheckError (waveInAddBuffer (WaveInHandle,PWaveHdr (Msg.LParam),SizeOf (TWaveHdr)))
End;

procedure TForm1.disp2;
var
  s,d: TRect;
  i,wid,n: word;
  bm: TBitmap;
begin
  for i:=0 to buf_len-1 do fft_s[i]:=complex(papoulis(i)*Form1.fft_buf[i],0);
  ForwardFFT(fft_s,fft_d,buf_len);
  for i:=0 to buf_len-1 do Form1.fft_disp[i]:=round(30*log10(power(ComplexMag(fft_d[i])*0.005+1,2)));
  s.Left:=0;
  s.Right:=PaintBox2.width;
  s.Top:=44;
  s.Bottom:=4;
  d.Left:=0;
  d.Right:=PaintBox2.width;
  d.Top:=45;
  d.Bottom:=5;
  n:=0;
  PaintBox2.Canvas.CopyRect(d,PaintBox2.canvas,s);
  wid := PaintBox2.width;
  if wid>buf_len div 2 then wid:=buf_len div 2;
  for i:=0 to wid-1 do
  begin
    n:=fft_disp[i];
    PaintBox2.Canvas.Pixels[i,4]:=65536*n+256*n+n;
  end;
end;

procedure TForm1.pointer;
var
  x: single;
begin
  x:=sec_1/buf_len;
  PaintBox2.Canvas.Pen.Color:=clWhite;
  PaintBox2.Canvas.Brush.Color:=clWhite;
  PaintBox2.Canvas.Rectangle(0,1,2047,3);
  PaintBox2.Canvas.Pen.Color:=clGreen;
  PaintBox2.Canvas.Rectangle(round((freq-shft/2)/x)-1,1,round((freq-shft/2)/x)+1,3);
  PaintBox2.Canvas.Rectangle(round((freq+shft/2)/x)-1,1,round((freq+shft/2)/x)+1,3);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  full:=false;
  n:=0; freq:=1200; shft:=600; baud:=600; _baud:=round(sec_1/baud);
  init_BPF(freq,shft);
  init_LPF;
  pointer;
  for i:=buf_size to buf_size-1 do Form1.fft_buf[i]:=0;
  for i:=0 to buffercount-1 do
  begin
    hWaveHeader[i] := 0;
    hWaveBuffer[i] := 0;
    pWaveBuffer[i] := nil;
    pWaveFmtEx := nil;
  end;
  StartRecording;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  StopRecording;
end;

end.
