function testTwoRateInterpolator2(fileName,M,D)
%
global idOfFig;
global dg;
%
% constans declaration
%
alphaM = 0.22;
alphaD = 0.22;
%
Fs = 8000;
Fc = 1800;
Fb = 2400;
L = Fs/Fb;
rL = round(L);
xLim = 10*Fb/2;
lambda = 8;
K = 5;
%
xLimA = [-2.0,2.0]; 
yLimA = xLimA;
markerSize  = 5;
dg = [0, 0.69, 0.31];
atten = 70;
dither = 45;
%
%============================================================
%
Mx = M;
Dx = D;
load(fileName);
w = wi(:)';
M = Mx;
D = Dx;
%
%============================================================
%
nfft=2048;
win = window(@blackmanharris,nfft);
%
[Pxx,f] = pwelch(w,win,nfft/2,nfft,Fs);
Pxx = fftshift(Pxx)/max(abs(Pxx));
N = length(Pxx);
if rem(N,2) == 1,
    fn=(-(N-1)/2:1:(N-1)/2)/N;
else
    fn=(-N/2:1:N/2-1)/N;
end
%
%============================================================
%
mode = 1; % SRRC filter
[wM,cHat,hM,N] = wiInterpolator2(w,M,D,alphaM,lambda,mode);
%
% =======================================================================
%
chM = fftshift(fft(hM,nfft));
chM = abs(chM);
chM = chM / max(chM);
%
figure()
idOfFig = idOfFig + 1;
%
Fs1 = D*Fb;
myTitle = [{'Spectrum of w_M[n] and amplitude responses of H_{SRRC,\alpha/D}';...
    ['M = ' num2str(M) '; D = ' num2str(D) '; N = ' num2str(N)]}];
%
%subplot(1,2,1)
plotPSD(wM,Fs1,myTitle,'b',atten,12000,0,1);
hold on
plot(fn*Fs1,20*log10(abs(chM)),'color','r','LineWidth',1);
hold off
%
title(myTitle);
legend('Welch power spectrum of w_M[n]',...
        ['|H_{\alpha/D}(F)|; \alpha = ' num2str(alphaM)],4);
%
xlabel('F [kHz] x 10');
os_x= 1200 * [-10,-8,-5,-4,-1,0,1,4,5,8,10] ;
set(gca,'xtick',os_x,'xgrid','on');
labs = {'-1.2','-0.96','-0.6','-0.48','-0.12','0',...
    '0.12','0.48','0.6','0.96','1.2'};
set(gca,'xticklabel',labs);
%
xlim([-xLim xLim]);
ylim([-atten 0]);
grid on;
%
savePlotAs('png',['wM[n]_spectrum_alphaM=' num2str(alphaM)],idOfFig);
%
% =======================================================================
%
coeffArr = [];
sigmaArr = [];
%
% nominal phase position
phiP = linspace(0, 2*pi);
c = exp(j*phiP);
%
for d = 0:1:(D - 1),
    %
    cHatd = [zeros(1,d) cHat(1,1:end-d)];
    cHatd_eye = [NaN .* ones(1,d) cHat(1,1:end-d)]; % to remove artefacts
                                                    % from graph (contributed by initial zeros)
    %
    % eyediagram
    idOfFig = idOfFig + 1;
    eyediagram2(cHatd_eye(1,1:2000),D,D,0,'b-',[],['M = ' num2str(M) '; D = ' num2str(D)]);
    set(gcf, 'color', 'white');
    savePlotAs('png',['eyediagram_cHat[m-d]_d=' num2str(d)],idOfFig);
    %
    cHatD = cHatd(1,1:D:length(cHatd));
    [cnHatD,cn0HatD,cAvg,sigma,coeff] = cNorm(cHatD);
    %
    coeffArr = horzcat(coeffArr, coeff);
    sigmaArr = horzcat(sigmaArr, sigma);
    %
    figure()
    idOfFig = idOfFig + 1;
    %
    subplot(1,2,1)
    myTitle1 = {'Scatter-plot of received symbols';...
        ['M = ' num2str(M) '; D = ' num2str(D) '; \sigma = ' num2str(sigma)]};
    plotScatter_short2(cnHatD, c, 'b', xLim, L, ...
        'real','imag',...
        xLimA,yLimA,myTitle1,markerSize,1);
    %
    set(gcf, 'color', 'white');
    savePlotAs('png','cHatD[n]',idOfFig);
    %
end
%
sigmaArr;
ind1 = find(sigmaArr == min(sigmaArr));
dopt = ind1 - 1;
%
cHatPhi = [NaN .* ones(1, dopt) cHat(1,1:end-dopt)];
cHatPhi_size = size(cHatPhi);
%
phid = angle(cHatPhi);
%
temp1 = phid(1,1:end-1);
temp2 = phid(1,2:end);
deltaPhid = temp2 - temp1;
ind = find(abs(deltaPhid) >= pi/2);
ind = ind + 1;
phid(ind) = NaN;
%
% eyediagram
idOfFig = idOfFig + 1;
eyediagram3(phid(1,1:2000),D,D,0,'b-',[],['M = ' num2str(M) '; D = ' num2str(D)]);
set(gcf, 'color', 'white');
savePlotAs('png',['eyediagram_phid_dopt=' num2str(dopt)],idOfFig);
%
%