function subFig2(w,s,Fs,L,modIndex,rollOff,lambda,N,sideLobeAtten)
%
global idOfFig;
global dg;
%
rL = round(L);
%
% modified instantaneous frequency estimator
fw = ife2(w,Fs);
%
maxNumOfSymb = floor(length(w)/rL);
t = 0:1/rL:maxNumOfSymb - 1;
%
ind = find(t <= maxNumOfSymb);
ind2 = find(t <= 100);
maxPos = ind(length(ind));
maxPos2 = ind2(length(ind2));
%
fw1 = fw(1,1:maxPos);
w1 = w(1,1:maxPos);
%
%
figure()
idOfFig = idOfFig + 1;
subplot(2,1,1)
plot(t(1,1:maxPos2),fw1(1,1:maxPos2));
title('Instantaneous Frequency');
grid on;
set(gcf, 'color', 'white');
savePlotAs('png','ife2',idOfFig)
%
plotIFHist(fw1,Fs,'IFE2 histogram')
%
%
w0 = nnPoints(w1,L);    % abs( fra[n/L] );
%
%
x1 = -2.0;
x2 = 2.0;
y1 = x1;
y2 = x2;
%
phiP = [0 (2/5)*pi (4/5)*pi (6/5)*pi (8/5)*pi];
c = exp(j*phiP);
%
w00 = w0';
w00(isnan(w0)) = 0;
w00 = w00';
[w0Hat,w0nHat,w0Avg,sigma,coeff] = cNorm(w1);
%
figure()
idOfFig = idOfFig + 1;
subplot(1,2,1)
%
titleCplxEnv = ['Scatter-plot of w_i[n_{m}], \sigma = ' num2str(sigma)];
phiP = linspace(0, 2*pi);
cc = exp(j*phiP);
plot(cc,'color','k');
hold on;
color = 'k';
plotMyCplxEnv2(w0,color,rollOff,modIndex,L,titleCplxEnv,1,x1,x2,y1,y2,lambda,N,5);
hold on;
plot(c,'color','g','LineStyle','none','LineWidth',1,'Marker','.','MarkerSize',16);
hold off;
%
subplot(1,2,2)
nfft = 2048;
win = window(@blackmanharris,nfft);
%
[per,f] = pwelch(s,win,nfft/2,nfft,Fs);
per = per/max(abs(per));
%
color = 'b';
plotMyPsd(f,per,color,rollOff,modIndex,L,sideLobeAtten,Fs,lambda,N)
%
savePlotAs('png','w[n_m]_and_PSD',idOfFig)
%
%