function h = srrcFilter(L,alpha,lambda)
%
% based on:
% http://www.gaussianwaves.com/2011/04/square-root-raised-cosine-filter-matchedsplit-filter-implementation-2/
%
global idOfFig;
%
N = round(2*lambda*L) + 1;
%
n = -((N-1)/2)/L:1/L:((N-1)/2)/L;
%
a = alpha;
p = zeros(1,length(n));
%
for i=1:1:length(n),
    if n(i)==0
        p(i) = (1 - a) + 4*a/pi;
    elseif n(i) == 1/(4*a) || n(i) == -1/(4*a)
        p(i) = a/sqrt(2)*((1+2/pi)*sin(pi/(4*a)+(1-2/pi)*cos(pi/(4*a))));
    else
        p(i) = (sin(pi*n(i)*(1-a))+4*a*n(i).*cos(pi*n(i)*(1+a))) ./ (pi*n(i).*(1-(4*a*n(i)).^2));
    end
end
%
h = p./sqrt(sum(p.^2)); % Normalization to unit energy
%
% ========================================================================
figure()
idOfFig = idOfFig + 1;
subplot(2,1,1)
myTitle = {['h_{SRRC,\alpha/L}[n]'];...
    ['\alpha = ' num2str(alpha) '; {\itL} = ' num2str(L) '; {\itN} = ' num2str(length(h))]};
t = 0:1:length(h)-1;
stem(t,h,'LineWidth',1,'MarkerSize',3);
title(myTitle);
xlabel([{'Samples [Sa]';''}])
xlim([0 (length(h)-1)]);
grid on
%
%
Fb = 2400;
nfft = 2048;
atten = 70;
Fs = L*Fb;
xLim = 10*Fb/2;
%
%
ch = fftshift(fft(h,nfft));
ch = abs(ch);
ch = ch / max(ch);
%
K = length(ch);
if rem(K,2) == 1,
    fn=(-(K-1)/2:1:(K-1)/2)/K;
else
    fn=(-K/2:1:K/2-1)/K;
end
%
subplot(2,1,2)
myTitle = [{'Amplitude responses of H_{SRRC,\alpha/L}';...
    ['\alpha = ' num2str(alpha) '; {\itL} = ' num2str(L) '; {\itN} = ' num2str(N)]}];
%
plot(fn*Fs,20*log10(abs(ch)),'color','r','LineWidth',1);
title(myTitle);
xlabel('F [kHz] x 10');
os_x= 1200 * [-10,-8,-5,-4,-1,0,1,4,5,8,10] ;
set(gca,'xtick',os_x,'xgrid','on');
labs = {'-1.2','-0.96','-0.6','-0.48','-0.12','0',...
    '0.12','0.48','0.6','0.96','1.2'};
set(gca,'xticklabel',labs);
%
xlim([-xLim xLim]);
ylim([-atten 0]);
grid on;
%
savePlotAs('png','hSRRC[n]',idOfFig);
%