function h = rcNyquist(L,alpha,lambda)
%
global idOfFig;
%
N = round(2*lambda*L) + 1;
n = 0:(N-1);
%
nom = cos((pi*alpha/L)*(n - ((N - 1)/2)));
denom = 1 - ((2*alpha/L)*(n - (N - 1)/2)).^2;
%
h = (nom / denom) .* sinc((1/L)*(n - (N - 1)/2));
%
h = h ./ sqrt(sum(h.^2)); % Normalization to unit energy
%
figure()
idOfFig = idOfFig + 1;
subplot(2,1,1)
myTitle = {['h_{RC,\alpha/L}; \alpha = ' num2str(alpha) '; L = ' num2str(L)]};
stem(n,h,'LineWidth',1,'MarkerSize',2);
title(myTitle);
xlabel([{'Samples [Sa]';''}])
grid on
set(gcf, 'color', 'white');
savePlotAs('png','hRC[n]',idOfFig);
%