function plotPSD(y,Fs,myTitle,color,atten,xLim,raw,db)
%
nfft=2048;
win = window(@blackmanharris,nfft);
%
if raw == 0,
    [Pxx,f] = pwelch(y,win,nfft/2,nfft,Fs,'twosided');
elseif raw == 1,
    [Pxx,f] = periodogram(y,[],[],Fs,'twosided');
end
%
Pxx = fftshift(Pxx)/max(abs(Pxx));
K = length(Pxx);
if rem(K,2) == 1,
    fn = (-(K-1)/2:1:(K-1)/2)/K;
else
    fn = (-K/2:1:K/2-1)/K;
end
plot(fn*Fs,10*log10(Pxx),'color',color);
%
%