function plotMyPsd(f,per,color,alpha,modIndex,L,sideLobeAtten,fs,lambda,N)
%
plot(f,10*log10(per),'color',color);
[nom,denom] = rat(modIndex);
myTitle = 'Welch Power Spectral Density of s_i[n]';
prepTitle = [{myTitle;...
                ['{\ith} ={ }' num2str(nom) '/' num2str(denom) ...
                '; \alpha = ' num2str(alpha) ...
                '; {\itN} = ' num2str(N)]}];
title(prepTitle);
xlabel([{'F [Hz]';''}]);
ylabel('PSD [dBc]')
os_x=[0:900:4000];
set(gca,'xtick',os_x,'xgrid','on');
ylim([sideLobeAtten,0])
axis square;
xlim([0 4000])
grid on;
set(gcf, 'color', 'white');
%