function mainWiMod(Fs,Fc,Br,modIndex,rollOff,mode)
%
% Br       = symbol rate (sym/sec). 
% Fs       = sample rate (sam/sec).
% modIndex = modulation index
% rollOff  = roll-off factor in the range of [0, 1]
% mode     = mode of wi[n] interpolator
%
% mainWiMod(8000,1800,2400,2/5,0.22,1) 
%
clc;
global idOfFig;
global dg;
%
idOfFig = 0;
%
%
lambda = 8;             % lambda means number of zero-crossing 
                        % of the RC filter's impulse response
%
xLim = 10*Br/2;
xLimA = [-2.0,2.0]; 
yLimA = xLimA;
markerSize  = 2;
dg = [0, 0.69, 0.31]; % my definition of green color
atten = 70;
%
%
[L,M] = rat(Fs/Br); % number of samples per symbol
%
rL = round(L);
%
% **************************** Message generator *************************
%
x = testGenMess(15000);
x = x(:)';
%
% **************************** SDPSK encoder (symbol precoder) ***********
omegaB = (pi * modIndex) * x;
%
% ------------------- PHASE ACCUMULATOR (PA)
alpha = zeros(1,length(x));
phiP = zeros(1,length(x));
%
phi0 = 0;
alpha(1) = omegaB(1)+ phi0;
phiP(1) = alpha(1);
for i=2:length(x),
    alpha(i) = omegaB(i) + phiP(i-1);
    phiP(i) = pwr(alpha(i));
end
%
c = exp(j*phiP);
%
% ------------------- RC/RRC interpolator
%
% w - complex envelope
% N - length of RC / RRC filter
%
K = 5; % number of "stars" in constelation diagram
%
[wL,wL,h,N] = wiInterpolator(c,L,rollOff,lambda,mode);
[wL,wL0Hat,wAvg,sigma,coeff] = cNorm(wL);
%
figure()
idOfFig = idOfFig + 1;
myTitle = {'Argand diagram of w_L[m]';...
    ['H_{\alpha/L}; \alpha = ' num2str(rollOff)...
    '; L = ' num2str(L)]};
plotScatter_wi(wL(1,1:4000), c, 'b', xLim, L, ...
    'real','imag',...
    xLimA,yLimA,myTitle,markerSize,0);
%
set(gcf, 'color', 'white');
savePlotAs('png','wL[n]',idOfFig);
%
%for d = 0:1:(L - 1),
d = 0;
wLd = [zeros(1,d) wL(1,1:end-d)];
cHatd = wLd(1,1:M:length(wLd));
[cnHatd,cn0Hatd,cAvg,sigma,coeff] = cNorm(cHatd);
if d == 0,
    wi = cnHatd;
    save(['wi_L=' num2str(L) '_M=' num2str(M) '_N=' num2str(N) '.mat'],'wi','N');
end
%
figure()
idOfFig = idOfFig + 1;
subplot(1,2,1)
if mode == 0,
    subTitle = ['H_{RC,\alpha/L}; \alpha = ' num2str(rollOff) ...
        '; L = ' num2str(L) '; M = ' num2str(M) ];
elseif mode == 1,
    subTitle = ['H_{SRRC,\alpha/L}; \alpha = ' num2str(rollOff) ...
        '; L = ' num2str(L) '; M = ' num2str(M) ];
elseif mode == 2,
    subTitle = ['H_{RC,\alpha/L}H_{RC,\alpha/L}; \alpha = ' num2str(rollOff) ...
        '; L = ' num2str(L) '; M = ' num2str(M) ];
elseif mode == 3,
    subTitle = ['H_{SRRC,\alpha/L}H_{SRRC,\alpha/L}; \alpha = ' num2str(rollOff) ...
        '; L = ' num2str(L) '; M = ' num2str(M) ];
elseif mode == 4,
    subTitle = ['H_{SRRC,\alpha/L}; \alpha = ' num2str(rollOff) ...
        '; L = ' num2str(L) '; M = ' num2str(M) ];
end
myTitle = {'Scatter-plot of received symbols';...
    subTitle;...
    ['d = ' num2str(d) '; \sigma = ' num2str(sigma)]};
plotScatter_wi(cnHatd, c, 'b', xLim, L, ...
    'real','imag',...
    xLimA,yLimA,myTitle,markerSize,1);
%
subplot(1,2,2)
myTitle = {'Argand diagram of received symbols';...
    subTitle;...
    ['d = ' num2str(d) '; \sigma = ' num2str(sigma)]};
plotScatter_wi(cnHatd, c, 'b', xLim, L, ...
    'real','imag',...
    xLimA,yLimA,myTitle,markerSize,0);
%
set(gcf, 'color', 'white');
savePlotAs('png','wi[n]',idOfFig);
%end
%
omegaC = 2*pi*(Fc/Fs);
n = 1:length(wi);
ui = wi .* exp(j*omegaC .* n);
s = real(ui);
%
L = (Fs/Br);
N = length(h);
subFig2(wi,s,Fs,L,modIndex,rollOff,lambda,N,-atten)
%
% ========================== Phase Wrapper ========================
% inner function
function pwrVal = pwr(alpha)
    pwrVal = 2*pi*fra(alpha/(2*pi));
%
%