function f2 = ife2(w,Fs)
%
% w - complex envelope
% f2 - modified IFE (that's why "f2")
%
w = w(:)';
N = length(w);
%
temp1 = angle(w(2:end-1) .* conj(w(1:end-2)));
temp2 = angle(w(3:end) .* conj(w(2:end-1)));
%
f2_1 = angle(w(2) .* conj(w(1)));
f2_N = angle(w(N) .* conj(w(N-1)));
%
omega2 = [f2_1 (temp2 + temp1)/2 f2_N]; % [rad/Sa]
f2 = (Fs / (2*pi)) .* omega2; % [Hz], belongs to [-Fs/2, Fs/2)
%