function fig1(w,Fs,myTitle1,myTitle2,atten,color)
%
global idOfFig;
%
xLimX = [-2 2];
yLimY = xLimX;
%
nfft=2048;
win = window(@blackmanharris,nfft);
%
[Pxx,f] = pwelch(w,win,nfft/2,nfft,Fs,'twosided');
%
Pxx = fftshift(Pxx)/max(abs(Pxx));
K = length(Pxx);
if rem(K,2) == 1,
    fn = (-(K-1)/2:1:(K-1)/2)/K;
else
    fn = (-K/2:1:K/2-1)/K;
end
%
figure()
idOfFig = idOfFig + 1;
%
% Argand diagram of complex envelope
%
phiP = [0 (2/5)*pi (4/5)*pi (6/5)*pi (8/5)*pi];
c = exp(j*phiP);
%
[wnHat,wn0Hat,cAvg,sigma] = cNorm(w);
%
subplot(1,2,1)
plot(wnHat(1,1:round(length(w)/30)),'color',color);
hold on;
title(myTitle1);
axis square
xlabel('real w[n]')
ylabel('imag w[n]')
grid on
%
ylim(yLimY);
xlim(xLimX);
hold on
tx = linspace(xLimX(1), xLimX(2));
l1 = zeros(1,length(tx));
plot(tx,l1,'LineWidth',1,'color','k');
hold on
ty = linspace(yLimY(1), yLimY(2));
t = zeros(1,length(ty));
plot(t,ty,'LineWidth',1,'color','k');
hold on
plot(c,'color','g','LineStyle','none','LineWidth',1,'Marker','.','MarkerSize',15);
hold off;
%
subplot(1,2,2)
plot(fn*Fs,10*log10(Pxx),'color',color);
title(myTitle2);
xlabel([{'F [Hz]';''}]);
ylabel('[dBc]')
xlim([-Fs/2 Fs/2]);
ylim([-atten 0])
grid on;
axis square;
%
set(gcf, 'color', 'white');
savePlotAs('png','Argand_diagram_PSD(w[n])',idOfFig)
%
%