#!/usr/bin/python -Ou
# -*- coding: utf-8 -*-
'''
This script is intedned to convert RadioScanner's Frequency Table
(http://www.radioscanner.ru/base/) into plain unicode HTML.

See the lines below "XXX" for entries that are not to be shown in the output.
Now, fields of "city", "confirmations", and "URLs" are not shown.
They are "hidden", not physically excluded.

This script requires a Python interpreter to run.
Developed and tested on Python 2.6.5.
Get your copy of Python at http://python.org/

License: Public Domain.

Author: jno (at) pisem (dot) net
'''

import sys, getopt
import csv

_HTML_head = u'''<!DOCTYPE html>
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<title>%(title)s</title>
<style type="text/css">
/* HTML4 standard table layout */
table               { display: table; border-spacing: 2px }
tr                  { display: table-row }
thead               { display: table-header-group }
tbody               { display: table-row-group }
tfoot               { display: table-footer-group }
col                 { display: table-column }
colgroup            { display: table-column-group }
td, th              { display: table-cell }
caption             { display: table-caption; text-align: center }
th                  { font-weight: bolder; text-align: center }
thead, tbody, tfoot { vertical-align: middle }
td, th, tr          { vertical-align: inherit }

/* specific setup */
table * { font-size: 5pt }
table, thead, tbody, tr, th, td { border-collapse: collapse; border: 1px solid black }
thead { background-color: silver }
th, td { vertical-align: top }

/* numeric fields should be right-aligned */
td.c0,td.c1,td.c2 { text-align: right; padding-right: 3px }

/* date/time fields are good when centered */
td.c3,td.c4 { text-align: center }

/* (XXX) these fields are not to be shown/printed here */
th.c5,td.c5,
th.c12,td.c12,
th.c13,td.c13
{ display: none }

</style>
<body>
<h1>%(title)s</h1>
<table>
'''

_HTML_tail = '''
</tbody>
</table>
</body>
</html>
'''

def handle( fname ):
  print fname
  ofp = open(fname+'.html','w')
  fp = open(fname)
  dp = csv.reader(fp,dialect='excel')
  ln = 0
  rn = 0
  header = None
  for row in dp :
    ln += 1
    if ln < 3 : continue
    if ln == 3 :
      ofp.write(_HTML_head % { u'title' : fname, } )
      thead = u'<thead><tr><th class="c0">№</th>'
      fn = 0
      for hdr in [field.decode('windows-1251') for field in row] :
        fn += 1
        thead += '<th class="c%d">%s</th>'%(fn,hdr)
      thead += u'</tr></thead>\n<tbody>\n'
      ofp.write( thead.encode('utf-8') )
    else:
      rn += 1
      data = '<tr><td class="c0">%d</td>'%(rn,)
      fn = 0
      for fld in [field.decode('windows-1251') for field in row]:
        fn += 1
        data += '<td class="c%d">%s</td>'%(fn,fld)
      data += '</td></tr>\n'
      ofp.write( data.encode('utf-8') )
  fp.close()
  ofp.close()
  print 'Records seen:',ln

def main():
  try:
    try:
      opts, args = getopt.getopt(
        sys.argv[1:],
	'?h',
	('help',)
      )
    except getopt.error, why:
      print >>sys.stderr, sys.argv[0],':',why
      return 1
    else:
      for o,v in opts :
        if o in ('-h','-?','--help'):
	  print 'HEEEEEELP!'
	  return 0
        pass
    if args :
      for arg in args :
        handle( arg )
    else:
      print sys.argv[0],'<CSV-file>'
      return 0
    return 0
  finally:
    pass

if __name__=='__main__' :
  sys.exit( main() )
# vim:ai:sts=2:et
# EOF #
