function sdpskModFigs(fs,fc,Br,modIndex,rollOff)
%
% Br = symbol rate (sym/sec). 
% fs = sample rate (sam/sec).
% modIndex = modulation index
% rollOff = roll-off factor in the range of [0, 1]
% shapeingFiltType = 0 (RC), = 1 (RRC)
clc;
close all;
%
if rollOff < 0 || rollOff > 1,
    error('>> Roll-off factor is not valid. Proper values are in the <0, 1> bracket.')
    s=[];Pxx=[];f=[];ia=[];fw=[];w=[];nu=[];g=[];
    
elseif modIndex <= 0 || modIndex > 1,
    error('>> Modulation index is not valid. Proper values are in the (0, 1> bracket.')
    s=[];Pxx=[];f=[];ia=[];fw=[];w=[];nu=[];g=[];
    
elseif (fc < (fs/4 - fs/8) || fc > (fs/4 + fs/8)) || (fs/Br < 4),
    error('>> Carrier frequency should be in the <fs/4 - fs/8, fs/4 + fs/8> bracket with L = fs/Br >= 4');
    s=[];Pxx=[];f=[];ia=[];fw=[];w=[];nu=[];g=[];
    
else
%
shapingFiltType = 0;
%
L = fs/Br;
nOfSymb = 16;% number of symbols to display
nOfSamples = nOfSymb*L;
%
t = 0:1:nOfSamples-1;
%
sideLobeAtten = -70;
%
%
%random message binary sequence
N = 50000;
rand('seed',111); % initializing the random state
bin = rand(N,1) > 0.5;
d = 2*bin-1; % {-1, +1}
%
% **************************** SDPSK encoder (symbol precoder) ***********
omegaB = d.*(pi*modIndex);
%
% ------------------- PHASE ACCUMULATOR (PA)
alpha = zeros(1,length(d));
phiP = zeros(1,length(d));
%
phi0 = 0;
alpha(1) = omegaB(1)+ phi0;
phiP(1) = alpha(1);
for i=2:length(d),
    alpha(i) = omegaB(i) + phiP(i-1);
    phiP(i) = pwr(alpha(i));
end
%
c = exp(j*phiP);
%
ci = real(c);
cq = imag(c);
% ------------------- RC/RRC interpolator
%
% zeroinserting
ciL = zeros(length(ci)*L,1);
ciL(1:L:length(ciL)) = ci;
%
cqL = zeros(length(cq)*L,1);
cqL(1:L:length(cqL)) = cq;
%
% RC/RRC filter 
%
%h = rcosine(1,fs/Br,'fir/sqrt',rollOff);
%
%hd = fdesign.pulseshaping(L,'Square Root Raised Cosine','N,Beta',60,rollOff);
%h = design(hd);
%h = h.Numerator;
%
lambda = 5; % default
switch shapingFiltType,
    case 0
        lambda = 6;
        h = rcfilter2(L,rollOff,lambda);
        % here lambda means number of zero-crossing 
        % of the RC-like filter's impulse response
        %filtType = 'Raised Cosine Filter (RC)';
    case 1
        h = rcosine(Br,fs,'fir/sqrt',rollOff);
        %filtType = 'Root Raised Cosine Filter (RRC)';
end
%
%figure()
plotMyH(h,fs,lambda,rollOff,L);
%
%
wi = filter(h,1,ciL);
wq = filter(h,1,cqL);
%
wi = wi((length(h)-1)+1:end);% elimination of the delay introduced by RC filter
wq = wq((length(h)-1)+1:end);%
%
% complex envelope
w = (wi + j*wq);
%
%
[n,d] = rat(modIndex);
%
% instantaneous amplitude
a = abs(w);
%
% instantaneous frequency estimator (IFE)
ife = angle(w(2:end).*conj(w(1:end-1)));
fw = fs.*ife/(2*pi);
%
% ------------------- Band shifting
n = [0:1:length(wi)-1];
omegaC = 2*pi*fc/fs;
u = w.*exp(j*omegaC*n.');
%
uHat = awgn(u,35,'measured');
ia = abs(uHat);
ife = angle(uHat(2:end).*conj(uHat(1:end-1)));
fw = fs.*ife/(2*pi);
%
s = real(uHat);
%
%
% converting signal into WAVE file
%
indMax = find(abs(s) == max(abs(s)));
extrVal = s(indMax(1));
if extrVal > 0,
    valMax = extrVal + 0.0025;
else
    valMax = extrVal - 0.0025;
end
%
snorm = s ./ abs(valMax);
%
if modIndex ~= 1 && rollOff ~= 1,
    [n1,d1] = rat(modIndex);
    [n2,d2] = rat(rollOff);
    fileName = ['sdpskSignal_h=' num2str(n1) '_' num2str(d1) ...
        '_alpha=' num2str(n2) '_' num2str(d2) '.wav'];
elseif modIndex == 1 && rollOff ~= 1,
    [n2,d2] = rat(rollOff);
    fileName = ['sdpskSignal_h=1' ...
        '_alpha=' num2str(n2) '_' num2str(d2) '.wav'];
elseif modIndex ~= 1 && rollOff == 1,
    [n1,d1] = rat(modIndex);
    fileName = ['sdpskSignal_h=' num2str(n1) '_' num2str(d1) ...
        '_alpha=1.wav'];
else
    fileName = ['sdpskSignal_h=1_alpha=1.wav'];
end
%
wavwrite(snorm,fs,16,fileName);
%
% ************************************************************************
%
% plotting IA and IF of SDPSK signal s[n]
figure()
subplot(2,1,1)
plotMyIAIF(t,ia(1:nOfSamples),modIndex,rollOff,L,'red','Instantaneous Amplitude');
subplot(2,1,2)
plotMyIAIF(t,fw(1:nOfSamples),modIndex,rollOff,L,'red','Instantaneous Frequency');
%
%
% Nu[n] vs. g[n] graph
w = w';
%
nu = 0.5*(abs(w(1,2:end-1) - w(1,1:end-2)) + abs(w(1,3:end) - w(1,2:end-1)));
nu = [nu];
%
cm = [1 j -1 -j].*exp(j*(0));
gg = [abs(w - cm(1,1)); abs(w - cm(1,2)); abs(w - cm(1,3)); abs(w - cm(1,4))];
gg = gg';
g = min(gg,[],2);
g = g';
g = g(1,1:end-2);
%
nOfSamples = nOfSamples*10;
figure()
titleCplxEnv = 'Complex Envelope of SDPSK signal s[n]';
subplot(1,2,1)
plotMyCplxEnv(w,'red',rollOff,modIndex,L,titleCplxEnv);
subplot(1,2,2)
titleNuVsG = '\nu_{w}[{\itn}] vs. {\itg}[{\itn}]';
%plotMyTransVel(g(1:nOfSamples),nu(1:nOfSamples),modIndex,rollOff,L,'red',titleNuVsG);
plotMyTransVel(g,nu,modIndex,rollOff,L,'red',titleNuVsG);
%
% IF histogram graph
figure()
plotMyIFHist(fw,fc,Br,modIndex,rollOff,L,'red');
%
% plotting Power Spectral Density of SDPSK signal s[n]
%
nfft=2048;
win = window(@kaiser,nfft,2.5);
%
[Pxx,f] = pwelch(s,win,nfft/2,nfft,fs);
Pxx=Pxx/max(abs(Pxx));
figure()
subplot(1,2,1)
titleCplxEnv = 'Complex Envelope of SDPSK signal s[n]';
plotMyCplxEnv(w,'red',rollOff,modIndex,L,titleCplxEnv);
subplot(1,2,2)
plotMyPsd(f,Pxx,'red',rollOff,modIndex,L,sideLobeAtten);
%
%
end
%
end
%
% ========================== Phase Wrapper ========================
function pwrVal = pwr(alpha)
    pwrVal = 2*pi*fra(alpha/(2*pi));
end
%
% ==========================
function f = fra(x)
    f = x - floor(x + 0.5);
end
%
%============================== my plot functions ========================
function plotMyH(h,fs,lambda,rollOff,L)
figure()
subplot(1,2,1)
N = 2*lambda*L + 1;
t = 0:1:(N-1);
stem(t,h,'MarkerSize',2);
[n,d]=rat(rollOff);
title([{['{\ith}_{\alpha/L}[{\itn}] for \alpha = ' num2str(n) '/' ...
    num2str(d) ', \lambda = ' num2str(lambda) ', {\itL} = ' ...
    num2str(L)]}])
ylim([-0.2 1.1])
xlim([0 (N-1)])
xlabel([{'n [Sa]';''}])
os_x=[0:L:N-1];
set(gca,'xtick',os_x,'xgrid','on');
set(gcf, 'color', 'white');
grid on;
%
subplot(1,2,2)
[ch,f] = freqz(h,1,[],fs);
ch = ch ./ max(abs(ch));
%
plot(f,abs(ch));
title([{['Frequency response for \alpha = ' num2str(n) '/' ...
    num2str(d) ', \lambda = ' num2str(lambda) ', {\itL} = ' ...
    num2str(L)]}])
ylim([0 1.1])
xlim([0 fs/4])
xlabel([{'F [Hz]';''}])
os_x=[0:250:fs/4];
set(gca,'xtick',os_x,'xgrid','on');
os_y=[0:0.25:1.1];
set(gca,'ytick',os_y,'ygrid','on');
grid on
end
%
function plotMyIAIF(t,a,modIndex,rollOff,L,color,myTitle)
%
plot(t,a,'color',color);
title(prepareTitle(modIndex,rollOff,L,myTitle));
xlabel([{'n [Sa]';''}]');
ylabel('IA')
os_x=[0:L:length(a)];
set(gca,'xtick',os_x,'xgrid','on');
xlim([0,length(a)])
%
minVal = min(a)-(max(a)-min(a))*0.1;
maxVal = max(a)+(max(a)-min(a))*0.1;
%
ylim([minVal maxVal]);
set(gcf, 'color', 'white');
grid on
end
%
function plotMyCplxEnv(w,color,rollOff,modIndex,L,myTitle)
%
plot(w,'color',color);
title(prepareTitle(modIndex,rollOff,L,myTitle));
%
axis square
grid on
ylabel('imag')
xlabel('real')
xlim([-1.2 1.2])
ylim([-1.2 1.2])
set(gcf, 'color', 'white');
end
%
function plotMyTransVel(g,nu,modIndex,rollOff,L,color,myTitle)
%
plot(g,nu,'color',color);
hold on 
plot((0:max(g)/1000:max(g)),2*sin(pi*modIndex/(2*L)),'k','LineWidth',2)
hold off
%
title(prepareTitle(modIndex,rollOff,L,myTitle)); 
%
axis square
grid on
xlabel('g[n]')
ylabel('\nu_w[n]')
%
maxVal = max(nu)+(max(nu)-min(nu))*0.1;
%
ylim([0 maxVal]);
%
maxVal = max(g)+(max(g)-min(g))*0.1;
%
xlim([0 maxVal]);
%
%ylim([0 0.3])
%xlim([0 0.9])
set(gcf, 'color', 'white');
end
%
function plotMyIFHist(fw,fc,Br,modIndex,rollOff,L,color)
%
myTitle = 'Instantaneous Frequency histogram';
%
max1 = max(abs(fw));
scale=0:1:max1;
[k,xout]=hist(fw,scale);
N=sum(k);
bar(xout,k/N,'BarWidth', 1,'FaceColor',color, 'EdgeColor',color)
title(prepareTitle(modIndex,rollOff,L,myTitle));
xlim([fc-Br fc+Br])
ylim([0 0.003])
xlabel([{'IF [Hz]';''}])
grid on
set(gcf, 'color', 'white');
end
%
function plotMyPsd(f,per,color,rollOff,modIndex,L,sideLobeAtten)
%
plot(f,10*log10(per),'color',color);
title(prepareTitle(modIndex,rollOff,L,'Welch Power Spectral Density of s[n]'));
xlabel([{'F [Hz]';''}]);
ylabel('PSD [dBc/Hz]')
os_x=[0:600:3600];
set(gca,'xtick',os_x,'xgrid','on');
ylim([sideLobeAtten,0])
axis square;
grid on;
set(gcf, 'color', 'white');
end
%
function prepTitle = prepareTitle(modIndex,rollOff,L,myTitle)
%
[nom,denom] = rat(rollOff);
[nom1,denom1] = rat(modIndex);
%

if rollOff ~= 1 && modIndex ~= 1,
    prepTitle = [{myTitle;...
        [...
        '{\ith} ={ }' num2str(nom1) '/' num2str(denom1) ...
        '; \alpha = ' num2str(nom) '/' num2str(denom) ...
        '; {\itL} = ' num2str(L)]}]; 
elseif rollOff ~= 1 && modIndex == 1,
    prepTitle = [{myTitle;...
        [...
        '{\ith} ={ }' num2str(modIndex) ...
        '; \alpha = ' num2str(nom) '/' num2str(denom)...
        '; {\itL} = ' num2str(L)]}];
elseif rollOff == 1 && modIndex ~= 1,
    prepTitle = [{myTitle;...
        [...
        '{\ith} ={ }' num2str(nom1) '/' num2str(denom1) ...
        '; \alpha = ' num2str(rollOff)...
        '; {\itL} = ' num2str(L)]}];
elseif rollOff == 1 && modIndex == 1,
    prepTitle = [{myTitle;...
        [...
        '{\ith} ={ }' num2str(modIndex) ...
        '; \alpha = ' num2str(rollOff)...
        '; {\itL} = ' num2str(L)]}];
end
end
%
    
    