function [s,Pxx,f,ia,fw,w,nu,g]=sdpskMod(fs,fc,Br,modIndex,rollOff)
%
% Br = symbol rate (sym/sec). 
% fs = sample rate (sam/sec).
% modIndex = modulation index
% rollOff = roll-off factor in the range of [0, 1]
% shapingFiltType = 0 (RC), = 1 (RRC)
%
%
if rollOff < 0 || rollOff > 1,
    error('>> Roll-off factor is not valid. Proper values are in the <0, 1> bracket.')
    s=[];Pxx=[];f=[];ia=[];fw=[];w=[];nu=[];g=[];
    
elseif modIndex <= 0 || modIndex > 1,
    error('>> Modulation index is not valid. Proper values are in the (0, 1> bracket.')
    s=[];Pxx=[];f=[];ia=[];fw=[];w=[];nu=[];g=[];
    
elseif (fc < (fs/4 - fs/8) || fc > (fs/4 + fs/8)) || (fs/Br < 4),
    error('>> Carrier frequency should be in the <fs/4 - fs/8, fs/4 + fs/8> bracket with L = fs/Br >= 4');
    s=[];Pxx=[];f=[];ia=[];fw=[];w=[];nu=[];g=[];
    
else
shapingFiltType = 0;
%
L = fs/Br;
%
%
%random message binary sequence
N = 50000;
rand('seed',111); % initializing the random state
bin = rand(N,1) > 0.5;
d = 2*bin-1; % {-1, +1}
%
nOfSymb = 16;
%
% **************************** SDPSK encoder (symbol precoder) ***********
omegaB = d.*(pi*modIndex);
%
% ------------------- PHASE ACCUMULATOR (PA)
alpha = zeros(1,length(d));
phiP = zeros(1,length(d));
%
phi0 = 0;
alpha(1) = omegaB(1)+ phi0;
phiP(1) = alpha(1);
for i=2:length(d),
    alpha(i) = omegaB(i) + phiP(i-1);
    phiP(i) = pwr(alpha(i));
end
%
c = exp(j*phiP);
%
ci = real(c);
cq = imag(c);
% ------------------- RC/RRC interpolator
%
% zeroinserting
ciL = zeros(length(ci)*L,1);
ciL(1:L:length(ciL)) = ci;
%
cqL = zeros(length(cq)*L,1);
cqL(1:L:length(cqL)) = cq;
%
% RC/RRC filter 
%
%h = rcosine(1,fs/Br,'fir/sqrt',rollOff);
%
%hd = fdesign.pulseshaping(L,'Square Root Raised Cosine','N,Beta',60,rollOff);
%h = design(hd);
%h = h.Numerator;
%
lambda = 5; % default
switch shapingFiltType,
    case 0
        lambda = 6;
        h = rcfilter2(L,rollOff,lambda);
        % here lambda means number of zero-crossing 
        % of the RC-like filter's impulse response
        filtType = 'Raised Cosine Filter (RC)';
    case 1
        h = rcosine(Br,fs,'fir/sqrt',rollOff);
        filtType = 'Root Raised Cosine Filter (RRC)';
end
%
wi = filter(h,1,ciL);
wq = filter(h,1,cqL);
%
wi = wi((length(h)-1)+1:end);% elimination of the delay introduced by RC filter
wq = wq((length(h)-1)+1:end);%
%
% complex envelope
w = (wi + j*wq);
%
% instantaneous amplitude (IA)
a = abs(w);
%
% instantaneous frequency estimator (IFE)
ife = angle(w(2:end).*conj(w(1:end-1)));
fw = fs.*ife/(2*pi);
%
% ------------------- Band shifting
n = [0:1:length(wi)-1];
omegaC = 2*pi*fc/fs;
u = w.*exp(j*omegaC*n.');
%
uHat = awgn(u,35,'measured');
ia = abs(uHat);
ife = angle(uHat(2:end).*conj(uHat(1:end-1)));
fw = fs.*ife/(2*pi);
%
s = real(uHat);
%
%
% converting signal into WAVE file
%
indMax = find(abs(s) == max(abs(s)));
extrVal = s(indMax(1));
if extrVal > 0,
    valMax = extrVal + 0.0025;
else
    valMax = extrVal - 0.0025;
end
%
snorm = s ./ abs(valMax);
%
if modIndex ~= 1 && rollOff ~= 1,
    [n1,d1] = rat(modIndex);
    [n2,d2] = rat(rollOff);
    fileName = ['sdpskSignal_h=' num2str(n1) '_' num2str(d1) ...
        '_alpha=' num2str(n2) '_' num2str(d2) '.wav'];
elseif modIndex == 1 && rollOff ~= 1,
    [n2,d2] = rat(rollOff);
    fileName = ['sdpskSignal_h=1' ...
        '_alpha=' num2str(n2) '_' num2str(d2) '.wav'];
elseif modIndex ~= 1 && rollOff == 1,
    [n1,d1] = rat(modIndex);
    fileName = ['sdpskSignal_h=' num2str(n1) '_' num2str(d1) ...
        '_alpha=1.wav'];
else
    fileName = ['sdpskSignal_h=1_alpha=1.wav'];
end
%
wavwrite(snorm,fs,16,fileName);
%
% ************************************************************************
%
% plotting Power Spectral Density of SDPSK signal s[n]
%
nfft=2048;
win = window(@kaiser,nfft,2.5);
%
[Pxx,f] = pwelch(s,win,nfft/2,nfft,fs);
Pxx=Pxx/max(abs(Pxx));
%
w = w';
%
nu = 0.5*(abs(w(1,2:end-1) - w(1,1:end-2)) + abs(w(1,3:end) - w(1,2:end-1)));
nu = [nu];
%

cm = [1 j -1 -j].*exp(j*(0));
gg = [abs(w - cm(1,1)); abs(w - cm(1,2)); abs(w - cm(1,3)); abs(w - cm(1,4))];
gg = gg';
%g = min(abs(gg),[],2);
g = min(gg,[],2);
g = g';
g = g(1,1:end-2);
end

%
% ========================== Phase Wrapper ========================
function pwrVal = pwr(alpha)
    pwrVal = 2*pi*fra(alpha/(2*pi));
%
% ==========================
function f = fra(x)
    f = x - floor(x + 0.5);
%
    
    