function sdpskFigs
clc;
close all;
%
fs = 8000;
fc = 1800;
Br = 1000;
L = fs/Br;
modIndex = 1/2;
[nom,denom] = rat(modIndex);
%
nOfSymb = 16; % number of symbols to display
nOfSamples = nOfSymb*L;
%
sideLobeAtten = -70;
%
t = 0:1:nOfSamples-1;
%
rollOff1 = 1/3;
%rollOff1 = 0.714;
rollOff2 = 2/3;
%rollOff2 = 0.857;
rollOff3 = 1;
%
% ================ instantaneous amplitude (IA) and frequency (IF) graphs
figure()
subplot(2,1,1)
%
[nom1,denom1] = rat(rollOff1);
[s1,per1,f1,a1,fw1,w1,nu1,g1] = sdpskMod(fs,fc,Br,modIndex,rollOff1);
plot(t,a1(1:nOfSamples),'b');
hold on;
%
[nom2,denom2] = rat(rollOff2);
[s2,per2,f2,a2,fw2,w2,nu2,g2] = sdpskMod(fs,fc,Br,modIndex,rollOff2);
plot(t,a2(1:nOfSamples),'r');
hold on;
%
[nom3,denom3] = rat(rollOff3);
[s3,per3,f3,a3,fw3,w3,nu3,g3]=sdpskMod(fs,fc,Br,modIndex,rollOff3);
plot(t,a3(1:nOfSamples),'g');
hold off;
%
title([{'Instantaneous amplitude';['{\ith} = ' num2str(nom) '/' num2str(denom) '; \itL = ' num2str(L)]}])
xlabel([{'n [Sa]';''}]');
ylabel('IA');
os_x=[0:L:nOfSamples];
set(gca,'xtick',os_x,'xgrid','on');
xlim([0,nOfSamples]);
ylim([0 1.3]);
legend(['\alpha = ' num2str(nom1) '/' num2str(denom1)],...
    ['\alpha = ' num2str(nom2) '/' num2str(denom2)],...
    ['\alpha = ' num2str(rollOff3)],4);
grid on;
set(gcf, 'color', 'white');
%
%
subplot(2,1,2)
%
plot(t,fw1(1:nOfSamples),'b')
hold on
%
plot(t,fw2(1:nOfSamples),'r')
hold on
%
plot(t,fw3(1:nOfSamples),'g')
%
title([{'Instantaneous frequency';['{\ith} = ' num2str(nom) '/' num2str(denom)  '; \itL = ' num2str(L)]}])
ylabel('IF [Hz]')
xlabel('n [Sa]');
os_x=[0:L:nOfSamples];
set(gca,'xtick',os_x,'xgrid','on');
xlim([0,nOfSamples]);
legend(['\alpha = ' num2str(nom1) '/' num2str(denom1)],...
    ['\alpha = ' num2str(nom2) '/' num2str(denom2)],...
    ['\alpha = ' num2str(rollOff3)],1);
set(gcf, 'color', 'white');
grid on
%
%
% ================ IF histograms
figure()
subplot(1,1,1)
plotMyIFHist(fw1,fc,Br,modIndex,rollOff1,L,'b')
%
figure()
subplot(1,1,1)
plotMyIFHist(fw2,fc,Br,modIndex,rollOff2,L,'r')
%
%
figure()
subplot(1,1,1)
plotMyIFHist(fw3,fc,Br,modIndex,rollOff3,L,'g')
%
%
nOfSamples = nOfSamples*10;
titleCplxEnv = 'Complex Envelope of SDPSK signal s[n]';
%
%========== Argand's diagrams of complex envelope and nu_w[n] vs. g[n] 
figure()
subplot(1,2,1)
plotMyCplxEnv(w1,'b',rollOff1,modIndex,L,titleCplxEnv);
%
subplot(1,2,2)
myTitle = '\nu_{w}[{\itn}] vs. {\itg}[{\itn}]';
plotMyTransVel(g1(1:nOfSamples),nu1(1:nOfSamples),modIndex,rollOff1,L,'b',myTitle)
%
figure()
subplot(1,2,1)
plotMyCplxEnv(w2,'r',rollOff2,modIndex,L,titleCplxEnv);
%
subplot(1,2,2)
plotMyTransVel(g2(1:nOfSamples),nu2(1:nOfSamples),modIndex,rollOff2,L,'r',myTitle)
%
figure()
subplot(1,2,1)
plotMyCplxEnv(w3,'g',rollOff3,modIndex,L,titleCplxEnv);
%
subplot(1,2,2)
plotMyTransVel(g3(1:nOfSamples),nu3(1:nOfSamples),modIndex,rollOff3,L,'g',myTitle)
%
%
% Argand's diagrams of complex envelope and nu_w[n] vs. g[n] for
% different modulation indexes
%
rollOff = 2/3;
modIndex1 = 1/4;
modIndex2 = 1/2;
modIndex3 = 2/3;
modIndex4 = 3/4;
modIndex5 = 1;
%
%
[s1,per1,f1,a1,fw1,w1,nu1,g1] = sdpskMod(fs,fc,Br,modIndex1,rollOff);
[omegaB1,phiPplot1,phiWplot1,phiUplot1,omegaW1,omegaU1,u1Cpfsk,...
    per1Cpfsk,f1Cpfsk,perS1,perW1,perU1] = cpfskMod(fs,fc,modIndex1,Br);
%
[s2,per2,f2,a2,fw2,w2,nu2,g2] = sdpskMod(fs,fc,Br,modIndex2,rollOff);
[omegaB2,phiPplot2,phiWplot2,phiUplot2,omegaW2,omegaU2,u2Cpfsk,...
    per2Cpfsk,f2Cpfsk,perS2,perW2,perU2] = cpfskMod(fs,fc,modIndex2,Br);
%
[s3,per3,f3,a3,fw3,w3,nu3,g3] = sdpskMod(fs,fc,Br,modIndex3,rollOff);
[omegaB3,phiPplot3,phiWplot3,phiUplot3,omegaW3,omegaU3,u3Cpfsk,...
    per3Cpfsk,f3Cpfsk,perS3,perW3,perU3] = cpfskMod(fs,fc,modIndex3,Br);
%
[s4,per4,f4,a4,fw4,w4,nu4,g4] = sdpskMod(fs,fc,Br,modIndex4,rollOff);
[omegaB4,phiPplot4,phiWplot4,phiUplot4,omegaW4,omegaU4,u4Cpfsk,...
    per4Cpfsk,f4Cpfsk,perS4,perW4,perU4] = cpfskMod(fs,fc,modIndex4,Br);
%
[s5,per5,f5,a5,fw5,w5,nu5,g5] = sdpskMod(fs,fc,Br,modIndex5,rollOff);
[omegaB5,phiPplot5,phiWplot5,phiUplot5,omegaW5,omegaU5,u5Cpfsk,...
    per5Cpfsk,f5Cpfsk,perS5,perW5,perU5] = cpfskMod(fs,fc,modIndex5,Br);
%
%
titleCplxEnv = 'Complex Envelope of SDPSK signal s[n]';
%
figure()
subplot(1,2,1)
plot(w1,'b');
plotMyCplxEnv(w1,'b',rollOff,modIndex1,L,titleCplxEnv);
%
subplot(1,2,2)
plotMyPsd(f1,per1,'b',rollOff,modIndex1,L,sideLobeAtten)
hold on
plotMyPsd(f1Cpfsk,per1Cpfsk,'k',rollOff,modIndex1,L,sideLobeAtten)
hold off
%
%
figure()
subplot(1,2,1)
plotMyCplxEnv(w2,'r',rollOff,modIndex2,L,titleCplxEnv);
%
subplot(1,2,2)
plotMyPsd(f2,per2,'r',rollOff,modIndex2,L,sideLobeAtten)
hold on
plotMyPsd(f2Cpfsk,per2Cpfsk,'k',rollOff,modIndex2,L,sideLobeAtten)
hold off
%
%
figure()
subplot(1,2,1)
plotMyCplxEnv(w3,'g',rollOff,modIndex3,L,titleCplxEnv);
%
subplot(1,2,2)
plotMyPsd(f3,per3,'g',rollOff,modIndex3,L,sideLobeAtten)
hold on
plotMyPsd(f3Cpfsk,per3Cpfsk,'k',rollOff,modIndex3,L,sideLobeAtten)
hold off
%
%
figure()
subplot(1,2,1)
plotMyCplxEnv(w4,'m',rollOff,modIndex4,L,titleCplxEnv);
%
subplot(1,2,2)
plotMyPsd(f4,per4,'m',rollOff,modIndex4,L,sideLobeAtten)
hold on
plotMyPsd(f4Cpfsk,per4Cpfsk,'k',rollOff,modIndex4,L,sideLobeAtten)
hold off
%
%
figure()
subplot(1,2,1)
plotMyCplxEnv(w5,[165/255 0 33/255],rollOff,modIndex5,L,titleCplxEnv);
%
subplot(1,2,2)
plotMyPsd(f5,per5,[165/255 0 33/255],rollOff,modIndex5,L,sideLobeAtten)
hold on
plotMyPsd(f5Cpfsk,per5Cpfsk,'k',rollOff,modIndex5,L,sideLobeAtten)
hold off
%
%
%{
nOfSamples = nOfSymb*L;
figure()
subplot(2,1,1)
plotMyIA(t,a5(1:nOfSamples),modIndex5,rollOff,L,[165/255 0 33/255]);
%
subplot(2,1,2)
plot(t,s5(1:nOfSamples),'color',[165/255 0 33/255]);
grid on
os_x=[0:L:nOfSamples];
set(gca,'xtick',os_x,'xgrid','on');
xlim([0,nOfSamples])
title(prepareTitle(modIndex5,rollOff,L,'Signal waveform'));
xlabel('n [Sa]')
ylabel('s[n]')
%}
%
end
%
%
%============================== my plot functions ========================
function plotMyPsd(f,per,color,rollOff,modIndex,L,sideLobeAtten)
%
plot(f,10*log10(per),'color',color);
title(prepareTitle(modIndex,rollOff,L,'Welch Power Spectral Density of s[n]'));
xlabel([{'F [Hz]';''}]);
ylabel('PSD [dBc/Hz]')
os_x=[0:600:3600];
set(gca,'xtick',os_x,'xgrid','on');
ylim([sideLobeAtten,0])
axis square;
grid on;
set(gcf, 'color', 'white');
end
%
%
function plotMyCplxEnv(w,color,rollOff,modIndex,L,myTitle)
%
plot(w,'color',color);
title(prepareTitle(modIndex,rollOff,L,myTitle));
%
axis square
grid on
ylabel('imag')
xlabel('real')
xlim([-1.2 1.2])
ylim([-1.2 1.2])
set(gcf, 'color', 'white');
end
%
% ================================
function plotMyTransVel(g,nu,modIndex,rollOff,L,color,myTitle)
%
plot(g,nu,'color',color);
hold on 
plot((0:max(g)/1000:max(g)),2*sin(pi*modIndex/(2*L)),'k','LineWidth',2)
hold off
%
title(prepareTitle(modIndex,rollOff,L,myTitle)); 
%
axis square
grid on
xlabel('g[n]')
ylabel('\nu_w[n]')
ylim([0 0.3])
xlim([0 0.9])
set(gcf, 'color', 'white');
end
%
% ================================
function plotMyIA(t,a,modIndex,rollOff,L,color)
%
plot(t,a,'color',color);
myTitle = 'Instantaneous Amplitude';
title(prepareTitle(modIndex,rollOff,L,myTitle));
%
xlabel([{'n [Sa]';''}]');
ylabel('IA')
set(gcf, 'color', 'white');
%
grid on
os_x=[0:L:length(a)];
set(gca,'xtick',os_x,'xgrid','on');
xlim([0,length(a)])
ylim([0 1.3])
set(gcf, 'color', 'white');
end
%
% ================================
function plotMyIFHist(fw,fc,Br,modIndex,rollOff,L,color)
%
myTitle = 'Instantaneous Frequency histogram';
%
max1 = max(abs(fw));
scale=0:1:max1;
[k,xout]=hist(fw,scale);
N=sum(k);
bar(xout,k/N,'BarWidth', 1,'FaceColor',color, 'EdgeColor',color)
title(prepareTitle(modIndex,rollOff,L,myTitle));
xlim([fc-Br fc+Br])
ylim([0 0.003])
xlabel([{'IF [Hz]';''}])
grid on
set(gcf, 'color', 'white');
end
%
% ================================
function prepTitle = prepareTitle(modIndex,rollOff,L,myTitle)
%
[nom,denom] = rat(rollOff);
[nom1,denom1] = rat(modIndex);
%

if rollOff ~= 1 && modIndex ~= 1,
    prepTitle = [{myTitle;...
        [...
        '{\ith} ={ }' num2str(nom1) '/' num2str(denom1) ...
        '; \alpha = ' num2str(nom) '/' num2str(denom) ...
        '; {\itL} = ' num2str(L)]}]; 
elseif rollOff ~= 1 && modIndex == 1,
    prepTitle = [{myTitle;...
        [...
        '{\ith} ={ }' num2str(modIndex) ...
        '; \alpha = ' num2str(nom) '/' num2str(denom)...
        '; {\itL} = ' num2str(L)]}];
elseif rollOff == 1 && modIndex ~= 1,
    prepTitle = [{myTitle;...
        [...
        '{\ith} ={ }' num2str(nom1) '/' num2str(denom1) ...
        '; \alpha = ' num2str(rollOff)...
        '; {\itL} = ' num2str(L)]}];
elseif rollOff == 1 && modIndex == 1,
    prepTitle = [{myTitle;...
        [...
        '{\ith} ={ }' num2str(modIndex) ...
        '; \alpha = ' num2str(rollOff)...
        '; {\itL} = ' num2str(L)]}];
end
end
%
%
