function [h] = rcfilter2(L,alpha,lambda)
% lambda = number of zero-crossing
% alpha = rolloff factor
%
%L = fs/fb;
%
% length of filter
N = 2*lambda*L + 1;
%
n = 0:1:N-1;
%
b = (sinc(alpha*(n - (N-1)/2)/(2*L)).^2).*sinc((n - (N-1)/2)/L);
%
%w = hamming(N)';
%w = blackman(N)';
%w = kaiser(N,9)';
w = 1;
%
h = w.*b;
%