clc; close all;
%
lambda = 5;
Br = 1600;
fs = 8000;
L = 5;
N = 2*lambda*L + 1;
t = 0:1:(N-1);
%
h1 = rcfilter2(L,3/10,lambda);
%
h1(1)
figure()
stem(t,h1)
[n,d]=rat(3/10);
title([{['{\ith}_{\alpha/L}[{\itn}] for \alpha = ' num2str(n) '/' ...
    num2str(d) ', \lambda = ' num2str(lambda) ', {\itL} = ' ...
    num2str(fs/Br)]}])
xlabel('n [Sa]')
ylim([-0.2 1.1])
xlim([0 (N-1)])
set(gcf, 'color', 'white');
grid on
%
%
lambda = 6;
Br = 1000;
fs = 8000;
L = fs/Br;
N = 2*lambda*(fs/Br) + 1;
t = 0:1:(N-1);
%
alpha1 = 1/3;
alpha2 = 2/3;
alpha3 = 1;
%
h2 = rcfilter2(L,alpha1,lambda);
h3 = rcfilter2(L,alpha2,lambda);
h4 = rcfilter2(L,alpha3,lambda);
%
figure()
stem(t,h2,'MarkerSize',2)
[n,d]=rat(alpha1);
title([{['{\ith}_{\alpha/L}[{\itn}] for \alpha = ' num2str(n) '/' ...
    num2str(d) ', \lambda = ' num2str(lambda) ', {\itL} = ' ...
    num2str(fs/Br)]}])
ylim([-0.2 1.1])
xlim([0 (N-1)])
xlabel([{'n [Sa]';''}])
os_x=[0:L:N-1];
set(gca,'xtick',os_x,'xgrid','on');
%axis tight
grid on
set(gcf, 'color', 'white');
%
figure()
subplot(3,2,1)
stem(t,h2,'MarkerSize',2)
[n,d]=rat(alpha1);
title([{['{\ith}_{\alpha/L}[{\itn}] for \alpha = ' num2str(n) '/' ...
    num2str(d) ', \lambda = ' num2str(lambda) ', {\itL} = ' ...
    num2str(fs/Br)]}])
ylim([-0.2 1.1])
xlim([0 (N-1)])
xlabel([{'n [Sa]';''}])
os_x=[0:L:N-1];
set(gca,'xtick',os_x,'xgrid','on');
%axis tight
grid on
%
[ch,f] = freqz(h2,1,[],fs);
ch = ch ./ max(abs(ch));
subplot(3,2,2)
%plot(f,20*log10(abs(ch)));
plot(f,abs(ch));
[n,d]=rat(alpha1);
title([{['Frequency response for \alpha = ' num2str(n) '/' ...
    num2str(d) ', \lambda = ' num2str(lambda) ', {\itL} = ' ...
    num2str(fs/Br)]}])
%ylim([-70 10])
ylim([0 1.1])
xlim([0 fs/4])
xlabel([{'F [Hz]';''}])
os_x=[0:250:fs/4];
set(gca,'xtick',os_x,'xgrid','on');
os_y=[0:0.25:1.1];
set(gca,'ytick',os_y,'ygrid','on');
%axis tight
grid on
%
subplot(3,2,3)
stem(t,h3,'MarkerSize',2)
[n,d]=rat(alpha2);
title([{['{\ith}_{\alpha/L}[{\itn}] for \alpha = ' num2str(n) '/' ...
    num2str(d) ', \lambda = ' num2str(lambda) ', {\itL} = ' ...
    num2str(fs/Br)]}])
ylim([-0.2 1.1])
xlim([0 (N-1)])
xlabel([{'n [Sa]';''}])
os_x=[0:L:N-1];
set(gca,'xtick',os_x,'xgrid','on');
%axis tight
grid on
%
[ch,f] = freqz(h3,1,[],fs);
ch = ch ./ max(abs(ch));
subplot(3,2,4)
%plot(f,20*log10(abs(ch)));
plot(f,abs(ch));
[n,d]=rat(alpha2);
title([{['Frequency response for \alpha = ' num2str(n) '/' ...
    num2str(d) ', \lambda = ' num2str(lambda) ', {\itL} = ' ...
    num2str(fs/Br)]}])
%ylim([-70 10])
ylim([0 1.1])
xlim([0 fs/4])
xlabel([{'F [Hz]';''}])
os_x=[0:250:fs/4];
set(gca,'xtick',os_x,'xgrid','on');
os_y=[0:0.25:1.1];
set(gca,'ytick',os_y,'ygrid','on');
%axis tight
grid on
%
subplot(3,2,5)
stem(t,h4,'MarkerSize',2)
[n,d]=rat(alpha3);
title([{['{\ith}_{\alpha/L}[{\itn}] for \alpha = ' num2str(alpha3) ...
    ', \lambda = ' num2str(lambda) ', {\itL} = ' ...
    num2str(fs/Br)]}])
ylim([-0.2 1.1])
xlim([0 (N-1)])
xlabel('n [Sa]')
os_x=[0:L:N-1];
set(gca,'xtick',os_x,'xgrid','on');
%axis tight
grid on
%
[ch,f] = freqz(h4,1,[],fs);
ch = ch ./ max(abs(ch));
subplot(3,2,6)
%plot(f,20*log10(abs(ch)));
plot(f,abs(ch));
[n,d]=rat(alpha3);
title([{['Frequency response for \alpha = ' num2str(alpha3) ...
    ', \lambda = ' num2str(lambda) ', {\itL} = ' ...
    num2str(fs/Br)]}])
%ylim([-70 10])
ylim([0 1.1])
xlim([0 fs/4])
xlabel([{'F [Hz]';''}])
os_x=[0:250:fs/4];
set(gca,'xtick',os_x,'xgrid','on');
os_y=[0:0.25:1.1];
set(gca,'ytick',os_y,'ygrid','on');
%axis tight
grid on
%
set(gcf, 'color', 'white');