function cpfskModFigs(fs,fc,modIndex,Br)
clc;
close all;
%
% Br = symbol rate (sym/sec). 
% fs = sample rate (sam/sec).
% modIndex = modulation index
%
%
if modIndex <= 0 || modIndex > 1,
    error('>> Modulation index is not valid. Proper values are in the (0, 1> bracket.')
    s=[];Pxx=[];f=[];ia=[];fw=[];w=[];nu=[];g=[];
    
elseif (fc < (fs/4 - fs/8) || fc > (fs/4 + fs/8)) || (fs/Br < 4),
    error('>> Carrier frequency should be in the <fs/4 - fs/8, fs/4 + fs/8> bracket with L = fs/Br >= 4');
    s=[];Pxx=[];f=[];ia=[];fw=[];w=[];nu=[];g=[];
    
else
%number of samples per symbol
%L=fs/Br;
%
l = fs/gcd(fs,Br); %greates common divisor
m = Br/gcd(fs,Br); % 
%
%modIndex=deltaF/Br;
deltaF = modIndex*Br;
%
%random message binary sequence
N = 50000;
rand('seed',111); % initializing the random state
bin = rand(N,1) > 0.5;
d = 2*bin-1; % {-1, +1}
%
nOfSymb = 16; % number of symbols to display
nOfSamples = nOfSymb*floor(fs/Br);
%
%interopolation filtering (zero order hold (ZOH_l/m))
[b, L] = zohNonInt(d,l,m);
%
%===================== b[n] graph ================================
figure()
t=0:1:nOfSymb*floor(L)-1;
stairs(t,b(1,1:nOfSymb*floor(L)),'LineWidth',2)%initial nOfSymbols
title([{'Binary message {\itb}_{\itL}[{\itn}]';['{\itF_B} ={ }' int2str(Br) '{ }Hz => {\itT_b} ={ }' ...
     int2str(fs) '/' int2str(Br) '{ }={ }' int2str(l) '/' int2str(m) '{ }Sa']}]);
xlabel('n [Sa]');
os_x=[0:floor(L):nOfSymb*floor(L)+floor(L)];
set(gca,'xtick',os_x,'xgrid','on');
ylim([-1.2 1.2]);
xlim([0 nOfSymb*floor(L)])
grid on;
set(gcf, 'color', 'white');
%
%
omegaB = b.*(pi*modIndex/L);
%
%
% ******************* PHASE ACCUMULATOR (PA)
alpha = zeros(1,length(b));
phiP = zeros(1,length(b));
%
phi0 = pi/4;
%phi0 = 0;
alpha(1) = omegaB(1)+ phi0;
phiP(1) = alpha(1);
for i=2:length(b),
    alpha(i) = omegaB(i) + phiP(i-1);
    phiP(i) = pwr(alpha(i));
end
%
%
phiPplot = phiP;
phiPTemp1 = phiP(1,1:end-1);
phiPTemp2 = phiP(1,2:end);
ind = find(abs(phiPTemp2 - phiPTemp1) >= pi);
%ind = find((pi + phiP) < 10^-14);
phiPplot(ind) = NaN;
%
% =============================== PA graph
%
figure()
subplot(2,1,1);
plotMyOmega(t,omegaB(1,1:nOfSamples),floor(fs/Br),'$\omega_b[n]$');
subplot(2,1,2);
plotMyPhi(t,phiPplot(1,1:nOfSamples),modIndex,floor(fs/Br),'$\varphi_{pb}[n]$');
%
%=======================================
%
w = exp(j*phiP);
phiW = angle(w);
%
%
phiWplot = phiW;
phiWTemp1 = phiW(1,1:end-1);
phiWTemp2 = phiW(1,2:end);
ind = find(abs(phiWTemp2 - phiWTemp1) >= pi);
%ind = find((pi + phiW) < 10^-14);
phiWplot(ind) = NaN;
%
omegaWTemp1 = w(1,1:end-1);
omegaWTemp2 = w(1,2:end);
omegaW = angle(omegaWTemp2.*conj(omegaWTemp1));
%
n = [0:1:length(phiP)-1];
omegaC = 2*pi*fc/fs*n;
%
u = w.*exp(j*omegaC);
%
s = real(u);
%s = awgn(s,25,'measured');
%
nfft=2048;
win = window(@kaiser,nfft,2.5);
%
[Pxx,f] = pwelch(s,win,nfft/2,nfft,fs);
Pxx=Pxx/max(abs(Pxx));
%
figure()
subplot(2,1,1)
plot(f,Pxx)
title('Welch Power Spectral Density of s[n]')
xlabel([{'F [Hz]';''}]);
ylabel('PSD [W/Hz]')
os_x=[0:200:fs/2];
set(gca,'xtick',os_x,'xgrid','on');
grid on;
subplot(2,1,2)
plot(f,10*log10(Pxx))
title('Welch Power Spectral Density of s[n]')
xlabel('F [Hz]');
ylabel('PSD [dBc/Hz]');
os_x=[0:200:fs/2];
set(gca,'xtick',os_x,'xgrid','on');
grid on;
set(gcf, 'color', 'white');
%
%
% normalization and writting into WAVE file
indMax = find(abs(s) == max(abs(s)));
extrVal = s(indMax(1));
if extrVal > 0,
    valMax = extrVal + 0.0025;
else
    valMax = extrVal - 0.0025;
end
%
snorm = s ./ abs(valMax);
%
if modIndex ~= 1,
    [n,d] = rat(modIndex);
    fileName = ['cpfskSignal_h=' num2str(n) '_' num2str(d) '.wav'];
else
    fileName = ['cpfskSignal_h=1.wav'];
end
wavwrite(snorm,fs,16,fileName);
%
% ==========================
phiU = angle(u);
%
phiUplot = phiU;
phiUTemp1 = phiU(1,1:end-1);
phiUTemp2 = phiU(1,2:end);
ind = find(abs(phiUTemp2 - phiUTemp1) >= pi);
phiUplot(ind) = NaN;
%
%
omegaUTemp1 = u(1,1:end-1);
omegaUTemp2 = u(1,2:end);
omegaU = angle(omegaUTemp2.*conj(omegaUTemp1));
%
%===== Instantaneous phase graphs of complex envelope w[n]and signal s[n]
%
figure()
subplot(2,1,1);
plotMyPhi(t,phiWplot(1,1:nOfSamples),modIndex,floor(fs/Br),'$\varphi_{w}[n]$');
subplot(2,1,2);
plotMyPhi(t,phiUplot(1,1:nOfSamples),modIndex,floor(fs/Br),'$\varphi_{u}[n]$');
%
%
% == Instantaneous frequency graphs of complex envelope w[n] and signal s[n]
%
figure()
subplot(2,1,1);
plotMyOmega(t,omegaW(1,1:nOfSamples),floor(fs/Br),'$\omega_{w}[n]$');
subplot(2,1,2);
plotMyOmega(t,omegaU(1,1:nOfSamples),floor(fs/Br),'$\omega_{u}[n]$');
%
%
% ************** Power Spectral Density of CPFSK signal s[n]
%
s = real(u)+j*eps;
%s = awgn(s,26,'measured');
%
[perS,f] = pwelch(s,win,nfft/2,nfft,fs);
%
[perW,fw] = pwelch(w,win,nfft/2,nfft,fs);
%
[perU,fu] = pwelch(u,win,nfft/2,nfft,fs);
%
sideLobeAtten = -55; 
figure()
plotMyPsd(perW,fs,'blue',sideLobeAtten);
hold on;
plotMyPsd(perS,fs,'red',sideLobeAtten);
hold on;
plotMyPsd(perU,fs,'green',sideLobeAtten);
hold off;
%
legend('w[n]','s[n]','u[n]',2);
title(prepareTitle(modIndex,floor(fs/Br),'Welch Power Spectral Density of w[n], s[n], u[n]'));
%
%
end
%
end
%
%
%========================= ZOH_l/m filtering
function [b,L] = zohNonInt(d,l,m)
    %
    %zeroinserting
    dl = zeros(length(d)*l,1);
    dl(1:l:length(dl)) = d;
    %
    %interopolation filtering (zero order hold (ZOH))
    h = ones(l,1);
    b = filter(h,1,dl);
    b = b';
    L = l;
    %
    if m > 1,
        bm = [zeros(1,m) b(1,1:length(b)-m)];
        b = bm(1,1:m:length(bm));
        L = l/m;
    end
end
%
%========================== Phase Wrapper ========================
function pwrVal = pwr(alpha)
    pwrVal = 2*pi*fra(alpha/(2*pi));
end
%==========================
function f = fra(x)
    f = x - floor(x + 0.5);
end
%
%============================== my plot functions ========================
function plotMyOmega(t,omega,L,myTitle)
    plot(t,omega,'LineWidth',2);
    set(get(gca,'title'),'Interpreter','latex')
    title(myTitle);
    set(get(gca,'title'),'FontSize',14);
    xlabel([{'n [Sa]';''}]);
    os_x=[0:L:length(omega)];
    %
    minVal = min(omega)-(max(omega)-min(omega))*0.15;
    maxVal = max(omega)+(max(omega)-min(omega))*0.15;
    %
    ylim([minVal maxVal]);
    xlim([0 length(omega)]);
    set(gca,'xtick',os_x,'xgrid','on');
    grid on;
    set(gcf, 'color', 'white');
end
%
function plotMyPhi(t,phi,modIndex,L,myTitle)
    plot(t,phi,'LineWidth',2);
    xlabel('n [Sa]');
    xlim([0 length(phi)]);
    %ylim([-pi pi]);
    os_x=[0:L:length(phi)];
    os_y=[-pi:pi*modIndex:pi];
    set(gca,'xtick',os_x,'xgrid','on');
    set(gca,'ytick',os_y,'xgrid','on');
    grid on;
    set(gcf, 'color', 'white');
    set(get(gca,'title'),'Interpreter','latex');
    title(myTitle);
    set(get(gca,'title'),'FontSize',14);
end
function plotMyPsd(per,fs,color,sideLobeAtten)
    per=fftshift(per)/max(abs(per));
    K=length(per);
    if rem(K,2)==1
        fn=(-(K-1)/2:1:(K-1)/2)/K;
    else
        fn=(-K/2:1:K/2-1)/K;
    end
    %
    if strcmp(color,'red'),
        plot(fn*fs,10*log10(per),'color',color,'LineWidth',2);
    else
        plot(fn*fs,10*log10(per),'color',color);
    end
    xlabel([{'F [Hz]';''}]);
    ylabel('PSD [dBc/Hz]')
    os_x=[-3600:600:3600];
    set(gca,'xtick',os_x,'xgrid','on');
    ylim([sideLobeAtten,0])
    grid on;
    set(gcf, 'color', 'white');
end
function prepTitle = prepareTitle(modIndex,L,myTitle)
    %
    [nom1,denom1] = rat(modIndex);
    %
    if modIndex ~= 1,
        prepTitle = [{myTitle;...
            [...
            '{\ith} ={ }' num2str(nom1) '/' num2str(denom1) ...
            '; {\itL} = ' num2str(L)]}]; 
    elseif modIndex == 1,
        prepTitle = [{myTitle;...
            [...
            '{\ith} ={ }' num2str(modIndex) ...
            '; {\itL} = ' num2str(L)]}];
    end
end