function [omegaB,phiPplot,phiWplot,phiUplot,omegaW,omegaU,u,...
    per0,f0,perS,perW,perU]=cpfskMod(fs,fc,modIndex,Br)
%
%number of samples per symbol
%L=fs/Br;
%
l = fs/gcd(fs,Br); %greates common divisor
m = Br/gcd(fs,Br); % 
%
%modIndex=deltaF/Br;
deltaF = modIndex*Br;
%
%random message binary sequence
N = 50000;
rand('seed',111); % initializing the random state
bin = rand(N,1) > 0.5;
d = 2*bin-1; % {-1, +1}
%
nOfSymb = 16;
d(1:nOfSymb);
%
%interopolation filtering (zero order hold (ZOH_l/m))
[b, L] = zohNonInt(d,l,m);
%
%===================== b[n] graph ================================
%
%
omegaB = b.*(pi*modIndex/L);
%
%
% ******************* PHASE ACCUMULATOR (PA)
alpha = zeros(1,length(b));
phiP = zeros(1,length(b));
%
phi0 = pi/4;
%phi0 = 0;
alpha(1) = omegaB(1)+ phi0;
phiP(1) = alpha(1);
for i=2:length(b),
    alpha(i) = omegaB(i) + phiP(i-1);
    phiP(i) = pwr(alpha(i));
end
%
phiPplot = phiP;
phiPTemp1 = phiP(1,1:end-1);
phiPTemp2 = phiP(1,2:end);
ind = find(abs(phiPTemp2 - phiPTemp1) >= pi);
%ind = find((pi + phiP) < 10^-14);
phiPplot(ind) = NaN;
%
w = exp(j*phiP);
phiW = angle(w);
%
phiWplot = phiW;
phiWTemp1 = phiW(1,1:end-1);
phiWTemp2 = phiW(1,2:end);
ind = find(abs(phiWTemp2 - phiWTemp1) >= pi);
phiWplot(ind) = NaN;
%
omegaWTemp1 = w(1,1:end-1);
omegaWTemp2 = w(1,2:end);
omegaW = angle(omegaWTemp2.*conj(omegaWTemp1));
%
n = [0:1:length(phiP)-1];
omegaC = 2*pi*fc/fs*n;
%
u = w.*exp(j*omegaC);
%
s = real(u);
%s = awgn(s,25,'measured');
%
nfft=2048;
win = window(@kaiser,nfft,2.5);
%
[per0,f0] = pwelch(s,win,nfft/2,nfft,fs);
per0=per0/max(abs(per0));
%
%
% normalization and converting into WAVE file
indMax = find(abs(s) == max(abs(s)));
extrVal = s(indMax(1));
if extrVal > 0,
    valMax = extrVal + 0.0025;
else
    valMax = extrVal - 0.0025;
end
%
snorm = s ./ abs(valMax);
%
if modIndex ~= 1,
    [n,d] = rat(modIndex);
    fileName = ['cpfskSignal_h=' num2str(n) '_' num2str(d) '.wav'];
else
    fileName = ['cpfskSignal_h=1.wav'];
end
wavwrite(snorm,fs,16,fileName);
%
% ==========================
phiU = angle(u);
%
phiUplot = phiU;
phiUTemp1 = phiU(1,1:end-1);
phiUTemp2 = phiU(1,2:end);
ind = find(abs(phiUTemp2 - phiUTemp1) >= pi);
phiUplot(ind) = NaN;
%
%
omegaUTemp1 = u(1,1:end-1);
omegaUTemp2 = u(1,2:end);
omegaU = angle(omegaUTemp2.*conj(omegaUTemp1));
%
%
% ************** Power Spectral Density of CPFSK signal s[n]
%
s = real(u)+j*eps;
%s = awgn(s,26,'measured');
%
[perS,f] = pwelch(s,win,nfft/2,nfft,fs);
%
%
[perW,fw] = pwelch(w,win,nfft/2,nfft,fs);
%
%
[perU,fu] = pwelch(u,win,nfft/2,nfft,fs);
%
%
end
%
%
%========================= ZOH_l/m filtering
function [b,L] = zohNonInt(d,l,m)
    %
    %zeroinserting
    dl = zeros(length(d)*l,1);
    dl(1:l:length(dl)) = d;
    %
    %interopolation filtering (zero order hold (ZOH))
    h = ones(l,1);
    b = filter(h,1,dl);
    b = b';
    L = l;
    %
    if m > 1,
        bm = [zeros(1,m) b(1,1:length(b)-m)];
        b = bm(1,1:m:length(bm));
        L = l/m;
    end
end
%
%========================== Phase Wrapper ========================
function pwrVal = pwr(alpha)
    pwrVal = 2*pi*fra(alpha/(2*pi));
end
%==========================
function f = fra(x)
    f = x - floor(x + 0.5);
end