function cpfskFigs
clc;
close all;
%
fs = 8000;
fc = 1800;
Br = 1000;
L = fs/Br;
modIndex = 1/2;
[nom,denom] = rat(modIndex);
%
nOfSymb = 16; % number of symbols to display
nOfSamples = nOfSymb*L;
%
t = 0:1:nOfSamples-1;
%
sideLobeAtten = -55;
%
[omegaB,phiPb,phiW,phiU,omegaW,omegaU,uCpfsk,...
    perCpfsk,fCpfsk,perS,perW,perU]=cpfskMod(fs,fc,modIndex,Br);
%
%=============================== PHASE ACCUMULATOR (PA) graphs
figure()
subplot(2,1,1);
plotMyOmega(t,omegaB(1,1:nOfSamples),L,'$\omega_b[n]$');
subplot(2,1,2);
plotMyPhi(t,phiPb(1,1:nOfSamples),modIndex,L,'$\varphi_{pb}[n]$');
%
%===== Instantaneous phase graphs of complex envelope w[n] and signal s[n]
figure()
subplot(2,1,1);
plotMyPhi(t,phiW(1,1:nOfSamples),modIndex,L,'$\varphi_{w}[n]$');
subplot(2,1,2);
plotMyPhi(t,phiU(1,1:nOfSamples),modIndex,L,'$\varphi_{u}[n]$');
%
%== Instantaneous frequency graphs of complex envelope w[n] and signal s[n]
figure()
subplot(2,1,1);
plotMyOmega(t,omegaW(1,1:nOfSamples),L,'$\omega_{w}[n]$');
subplot(2,1,2);
plotMyOmega(t,omegaU(1,1:nOfSamples),L,'$\omega_{u}[n]$');
%
%
% Power Spectral Density (PSD) comparision for different modulation indexes
modIndex1 = 1/4;
modIndex2 = 1/2;
modIndex3 = 2/3;
modIndex4 = 3/4;
modIndex5 = 1;
%
[omegaB1,phiPb1,phiW1,phiU1,omegaW1,omegaU1,u1Cpfsk,...
    perCpfsk1,fCpfsk1,perS1,perW1,perU1] = cpfskMod(fs,fc,modIndex1,Br);
%
[omegaB2,phiPb2,phiW2,phiU2,omegaW2,omegaU2,u2Cpfsk,...
    perCpfsk2,fCpfsk2,perS2,perW2,perU2] = cpfskMod(fs,fc,modIndex2,Br);
%
[omegaB3,phiPb3,phiW3,phiU3,omegaW3,omegaU3,u3Cpfsk,...
    perCpfsk3,fCpfsk3,perS3,perW3,perU3] = cpfskMod(fs,fc,modIndex3,Br);
%
[omegaB4,phiPb4,phiW4,phiU4,omegaW4,omegaU4,u4Cpfsk,...
    perCpfsk4,fCpfsk4,perS4,perW4,perU4] = cpfskMod(fs,fc,modIndex4,Br);
%
[omegaB5,phiPb5,phiW5,phiU5,omegaW5,omegaU5,u5Cpfsk,...
    perCpfsk5,fCpfsk5,perS5,perW5,perU5] = cpfskMod(fs,fc,modIndex5,Br);
%
figure()
plotMyPsd(perW1,fs,'blue',sideLobeAtten);
hold on;
plotMyPsd(perS1,fs,'red',sideLobeAtten);
hold on;
plotMyPsd(perU1,fs,'green',sideLobeAtten);
hold off;
%
legend('w[n]','s[n]','u[n]',2);
title(prepareTitle(modIndex1,L,'Welch Power Spectral Density of w[n], s[n], u[n]'));
%
figure()
plotMyPsd(perW2,fs,'blue',sideLobeAtten);
hold on;
plotMyPsd(perS2,fs,'red',sideLobeAtten);
hold on;
plotMyPsd(perU2,fs,'green',sideLobeAtten);
hold off;
%
legend('w[n]','s[n]','u[n]',2);
title(prepareTitle(modIndex2,L,'Welch Power Spectral Density of w[n], s[n], u[n]'));
%
figure()
plotMyPsd(perW3,fs,'blue',sideLobeAtten);
hold on;
plotMyPsd(perS3,fs,'red',sideLobeAtten);
hold on;
plotMyPsd(perU3,fs,'green',sideLobeAtten);
hold off;
%
legend('w[n]','s[n]','u[n]',2);
title(prepareTitle(modIndex3,L,'Welch Power Spectral Density of w[n], s[n], u[n]'));
%
figure()
plotMyPsd(perW4,fs,'blue',sideLobeAtten);
hold on;
plotMyPsd(perS4,fs,'red',sideLobeAtten);
hold on;
plotMyPsd(perU4,fs,'green',sideLobeAtten);
hold off;
%
legend('w[n]','s[n]','u[n]',2);
title(prepareTitle(modIndex4,L,'Welch Power Spectral Density of w[n], s[n], u[n]'));
%
figure()
plotMyPsd(perW5,fs,'blue',sideLobeAtten);
hold on;
plotMyPsd(perS5,fs,'red',sideLobeAtten);
hold on;
plotMyPsd(perU5,fs,'green',sideLobeAtten);
hold off;
%
legend('w[n]','s[n]','u[n]',2);
title(prepareTitle(modIndex5,L,'Welch Power Spectral Density of w[n], s[n], u[n]'));
%
%   
end
%
%
%============================== my plot functions ========================
function plotMyOmega(t,omega,L,myTitle)
    plot(t,omega,'LineWidth',2);
    set(get(gca,'title'),'Interpreter','latex')
    title(myTitle);
    set(get(gca,'title'),'FontSize',14);
    xlabel([{'n [Sa]';''}]);
    os_x=[0:L:length(omega)];
    %
    minVal = min(omega)-(max(omega)-min(omega))*0.15;
    maxVal = max(omega)+(max(omega)-min(omega))*0.15;
    %
    ylim([minVal maxVal]);
    xlim([0 length(omega)]);
    set(gca,'xtick',os_x,'xgrid','on');
    grid on;
    set(gcf, 'color', 'white');
end
%
function plotMyPhi(t,phi,modIndex,L,myTitle)
    plot(t,phi,'LineWidth',2);
    xlabel('n [Sa]');
    xlim([0 length(phi)]);
    %ylim([-pi pi]);
    os_x=[0:L:length(phi)];
    os_y=[-pi:pi*modIndex:pi];
    set(gca,'xtick',os_x,'xgrid','on');
    set(gca,'ytick',os_y,'xgrid','on');
    grid on;
    set(gcf, 'color', 'white');
    set(get(gca,'title'),'Interpreter','latex');
    title(myTitle);
    set(get(gca,'title'),'FontSize',14);
end
%
function plotMyPsd(per,fs,color,sideLobeAtten)
    per=fftshift(per)/max(abs(per));
    K=length(per);
    if rem(K,2)==1
        fn=(-(K-1)/2:1:(K-1)/2)/K;
    else
        fn=(-K/2:1:K/2-1)/K;
    end
    %
    if strcmp(color,'red'),
        plot(fn*fs,10*log10(per),'color',color,'LineWidth',2);
    else
        plot(fn*fs,10*log10(per),'color',color);
    end
    xlabel([{'F [Hz]';''}]);
    ylabel('PSD [dBc/Hz]')
    os_x=[-3600:600:3600];
    set(gca,'xtick',os_x,'xgrid','on');
    ylim([sideLobeAtten,0])
    grid on;
    set(gcf, 'color', 'white');
end
%
% ================================
function prepTitle = prepareTitle(modIndex,L,myTitle)
    %
    [nom1,denom1] = rat(modIndex);
    %
    if modIndex ~= 1,
        prepTitle = [{myTitle;...
            [...
            '{\ith} ={ }' num2str(nom1) '/' num2str(denom1) ...
            '; {\itL} = ' num2str(L)]}]; 
    elseif modIndex == 1,
        prepTitle = [{myTitle;...
            [...
            '{\ith} ={ }' num2str(modIndex) ...
            '; {\itL} = ' num2str(L)]}];
    end
end

